package tiger;

import java.io.IOException;
import java.io.LineNumberReader;

/**
 * Class for representing the Record Type 1 = Complete Chain Basic Record.
 * 
 * @version	1.10	18.08.2003	revised
 * @version	1.00	01.12.1998	first version
 * @author FH Oldenbzrg
 */
public class ChainBasicData {
	
	protected short version = 0;			// Version number
	private long tlId = 0;					// TIGER/Line ID, permanent record number
	protected boolean side1 = false;		// Single-side complete chain code?
	protected char source = ' ';			// Source or first source code of update
	protected String feDirP = null;			// Feature direction, prefix
	protected String feName = null;			// Feature name
	protected String feType = null;			// Feature type
	protected String feDirS = null;			// Feature direction, suffix
	protected String cfcc = null;			// Census feature class code
	protected long frAddL = 0;				// Start address, left
	protected long toAddL = 0;				// End address, left
	protected long frAddR = 0;				// Start address, right
	protected long toAddR = 0;				// End address, right
	protected boolean frIAddL = false;		// Start imputed address flag, left
	protected boolean toIAddL = false;		// End imputed address flag, left
	protected boolean frIAddR = false;		// Start imputed address flag, right
	protected boolean toIAddR = false;		// End imputed address flag, right
	protected int zipL = 0;					// ZIP code, left
	protected int zipR = 0;					// ZIP code, right
	protected int fairL = 0;				// FIPS 55 code, left
	protected int fairR = 0;				// FIPS 55 code, right
	protected char trustL = ' ';			// American indian trust land flag, current left
	protected char trustR = ' ';			// American indian trust land flag, current right
	protected char census1 = ' ';			// Census internal use
	protected char census2 = ' ';			// Census internal use
	protected short stateL = 0;				// FIPS state code, current left
	protected short stateR = 0;				// FIPS state code, current right
	protected short countyL = 0;			// FIPS county code, current left
	protected short countyR = 0;			// FIPS county code, current right
	protected int fmcdL = 0;				// FIPS 55 code (MCD/CCD), current left
	protected int fmcdR = 0;				// FIPS 55 code (MCD/CCD), current right
	protected int fsmcdL = 0;				// FIPS 55 code (sub-MCD), current left
	protected int fsmcdR = 0;				// FIPS 55 code (sub-MCD), current right
	protected int fplL = 0;					// FIPS 55 code (incorporated place), current left
	protected int fplR = 0;					// FIPS 55 code (incorporated place), current right
	protected int ctbnaL = 0;				// Census tract/BNA code, current left
	protected int ctbnaR = 0;				// Census tract/BNA code, current right
	protected int blkL = 0;					// Block number, current left
	protected int blkR = 0;					// Block number, current right
	protected int frLong = 0;				// Start longitude
	protected int frLat = 0;				// Start latitude
	protected int toLong = 0;				// End longitude
	protected int toLat = 0;				// End latitude

/**
 * Constructor.
 */
protected ChainBasicData () {
}

/**
 * Returns the record identifier.
 * @return  the id
 */
public long getID () {
	return tlId;
}

/**
 * Returns the record size on the file.
 * @return  the size in bytes
 */
public static int getRecordSize () {
	return 230;
}

/**
 * Reads a record from the input stream.
 * Not all fields are set.
 * @return  this object (or null if the end of file is reached)
 * @param  in  a LineNumberReader object
 */
public ChainBasicData read (LineNumberReader in) {
	String line = null;
	try {
		line = in.readLine();
		if (line == null)
			return null;
		char recType = line.charAt(0);
		if (recType != '1')
			throw new RuntimeException("Wrong record type: "+recType);
		tlId = Long.parseLong(line.substring(5,15).trim());
		feName = line.substring(19,49).trim();
		feType = line.substring(49,53).trim();
		cfcc = line.substring(55,58).trim();
		frLong = Integer.parseInt(line.substring(190,200));
		frLat = Integer.parseInt(line.substring(201,209));
		toLong = Integer.parseInt(line.substring(209,219));
		toLat = Integer.parseInt(line.substring(220,228));
		return this;
	} catch (IOException ex) {
		return null;
	}
}

}