/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import util.EntryInput;

public class BufferedEntryReader
extends BufferedReader
implements EntryInput {
    private char[] buffer = null;
    private final int maxBufferSize = 8192;
    private boolean eol = false;
    private boolean eof = false;
    private boolean numErr = false;
    private int nextEntryLength = 0;
    private char terminatingChar = (char)9;

    public BufferedEntryReader(InputStream in) {
        super(new InputStreamReader(in));
        this.buffer = new char[8192];
    }

    public BufferedEntryReader(InputStream in, int sz) {
        super(new InputStreamReader(in), sz);
        this.buffer = new char[8192];
    }

    public BufferedEntryReader(Reader in) {
        super(in);
        this.buffer = new char[8192];
    }

    public BufferedEntryReader(Reader in, int sz) {
        super(in, sz);
        this.buffer = new char[8192];
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean eol() {
        return this.eol;
    }

    public boolean numErr() {
        return this.numErr;
    }

    public boolean readBoolean() {
        char c = this.readChar();
        return c == '1';
    }

    public char readChar() {
        int c = 0;
        try {
            c = super.read();
            if (c < 0) {
                c = 0;
                this.eof = true;
            }
            this.eol = c == 10 || c == 13;
            return (char)c;
        }
        catch (IOException io) {
            this.eof = true;
            return (char)c;
        }
    }

    public double readDouble() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Double(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0.0;
            }
        }
        this.numErr = true;
        return 0.0;
    }

    public int readInt() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Integer(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0;
            }
        }
        this.numErr = true;
        return 0;
    }

    public long readLong() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Long(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0L;
            }
        }
        this.numErr = true;
        return 0L;
    }

    public short readShort() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Short(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0;
            }
        }
        this.numErr = true;
        return 0;
    }

    public String readString() {
        int i = 0;
        try {
            int c;
            do {
                if ((c = super.read()) < 0) {
                    this.buffer[i] = 32;
                    this.eof = true;
                    break;
                }
                this.buffer[i] = (char)c;
            } while (this.buffer[i] != '\n' && this.buffer[i] != '\r' && this.buffer[i] != this.terminatingChar && ++i < 8192 && i != this.nextEntryLength);
            boolean bl = this.eol = this.buffer[i] == '\n' || this.buffer[i] == '\r';
            if (!this.eof && i < 8192 && this.buffer[i] == '\r') {
                super.mark(1);
                c = super.read();
                if ((char)c != '\n') {
                    super.reset();
                }
            }
            if (!this.eof || i > 0) {
                return new String(this.buffer, 0, i);
            }
            return null;
        }
        catch (IOException io) {
            this.eof = true;
            if (i > 0) {
                return new String(this.buffer, 0, i);
            }
            return null;
        }
    }

    public short readWord2() {
        char ch1 = this.readChar();
        char ch2 = this.readChar();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readWord4() {
        char ch1 = this.readChar();
        char ch2 = this.readChar();
        char ch3 = this.readChar();
        char ch4 = this.readChar();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public void setNextEntryLength(int length) {
        this.nextEntryLength = length;
    }

    public void setTerminatingChar(char t) {
        this.terminatingChar = t;
    }
}

