/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import spatial.MBR;
import spatial.RTreeStrategy;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeNode;

public class SimpleRTreeStrategy
implements RTreeStrategy {
    protected int reinsertFactor = 0;
    protected int m = 40;
    protected BitSet indicator = new BitSet(128);

    public SimpleRTreeStrategy() {
        this(0);
    }

    public SimpleRTreeStrategy(int reinsertFactor) {
        this.reinsertFactor = reinsertFactor;
    }

    public int chooseSubtree(SpatialSearchTreeNode node, SpatialSearchTreeEntry obj) {
        MBR objRect = obj.getMBR();
        int num = node.getNumberOfEntries();
        int bestIndex = 0;
        MBR entryRect = node.getEntryMBR(bestIndex);
        double bestEntryArea = entryRect.computeVolume();
        double bestArea = entryRect.union(objRect).computeVolume() - bestEntryArea;
        int i = 1;
        while (i < num) {
            entryRect = node.getEntryMBR(i);
            double entryArea = entryRect.computeVolume();
            double area = entryRect.union(objRect).computeVolume() - entryArea;
            if (area < bestArea || area == bestArea && entryArea < bestEntryArea) {
                bestArea = area;
                bestEntryArea = entryArea;
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    public BitSet distribute(SpatialSearchTreeNode node, SpatialSearchTreeEntry entry) {
        MBR mbr = entry.getMBR();
        MBR actRect = node.getEntryMBR(0);
        int num = node.getNumberOfEntries();
        int distNum = 0;
        int axis = 0;
        int ext = mbr.extension(0);
        int i = 1;
        while (i < mbr.numOfDimensions()) {
            if (mbr.extension(i) > ext) {
                axis = i;
                ext = mbr.extension(i);
            }
            ++i;
        }
        long c = actRect.center(axis);
        int i2 = 1;
        while (i2 < num) {
            actRect = node.getEntryMBR(i2);
            c += (long)actRect.center(axis);
            ++i2;
        }
        int median = (int)(c / (long)num);
        int i3 = 0;
        while (i3 < num) {
            actRect = node.getEntryMBR(i3);
            if (actRect.center(axis) > median) {
                this.indicator.set(i3);
                ++distNum;
            } else {
                this.indicator.clear(i3);
            }
            ++i3;
        }
        if (distNum == 0 || distNum == num) {
            i3 = 0;
            while (i3 < num) {
                if (i3 >= num / 2) {
                    this.indicator.set(i3);
                } else {
                    this.indicator.clear(i3);
                }
                ++i3;
            }
        }
        return this.indicator;
    }

    public int getMinimum() {
        return this.m;
    }

    public int getReinsertFactor(int height) {
        return this.reinsertFactor;
    }

    public boolean isOrdering() {
        return false;
    }

    public void readParameters(DataInputStream in) throws IOException {
        this.m = in.readInt();
        this.reinsertFactor = in.readInt();
    }

    public void setMinimum(int m) {
        this.m = m;
    }

    public void setReinsertFactor(int p) {
        this.reinsertFactor = p;
    }

    public void sortAccordingTo(SpatialSearchTreeNode nd, double[] value, int left, int right) {
        this.sortAccordingTo(nd, value, 0, left, right);
    }

    public void sortAccordingTo(SpatialSearchTreeNode node, double[] value, int leftBorder, int left, int right) {
        if (right > left && right >= leftBorder) {
            double x3;
            double x1 = value[left];
            double x2 = value[(left + right) / 2];
            double x = x3 = value[right];
            if (x1 <= x2 && x2 <= x3 || x1 >= x2 && x2 >= x3) {
                x = x2;
            } else if (x2 <= x1 && x1 <= x3 || x2 >= x1 && x1 >= x3) {
                x = x1;
            }
            int i = left;
            int j = right;
            while (true) {
                if (value[i] < x) {
                    ++i;
                    continue;
                }
                while (value[j] > x) {
                    --j;
                }
                if (i <= j) {
                    SpatialSearchTreeEntry he = node.getEntry(j);
                    double hv = value[j];
                    node.setEntry(node.getEntry(i), j);
                    value[j] = value[i];
                    node.setEntry(he, i);
                    value[i] = hv;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            this.sortAccordingTo(node, value, left, j);
            this.sortAccordingTo(node, value, i, right);
        }
    }

    public void sortForReinsert(SpatialSearchTreeNode node) {
        int num = node.getNumberOfEntries();
        int distNum = num * this.getReinsertFactor(node.getHeight()) / 100;
        int[] m = node.getMBR().getCenterCoords();
        double[] dist = new double[num];
        int i = 0;
        while (i < num) {
            dist[i] = node.getEntry(i).getMBR().quadDistanceFromCenter(m);
            ++i;
        }
        this.sortAccordingTo(node, dist, num - distNum, 0, num - 1);
        int i1 = num - distNum;
        int i2 = num - 1;
        while (i1 < i2) {
            SpatialSearchTreeEntry h = node.getEntry(i1);
            node.setEntry(node.getEntry(i2), i1);
            node.setEntry(h, i2);
            ++i1;
            --i2;
        }
    }

    public void writeParameters(DataOutputStream out) throws IOException {
        out.writeInt(this.m);
        out.writeInt(this.reinsertFactor);
    }
}

