/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import spatial.BasicSpatialQuery;
import spatial.MBR;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeObject;
import spatial.VisualizedSpatialSearchTreeObject;

public class SelectQuery
extends BasicSpatialQuery {
    private int scale = 0;

    public SelectQuery(int scale) {
        this.scale = scale;
    }

    public boolean conditionFulfilled(MBR rect, MBR entryMBR) {
        if (rect == null || entryMBR == null) {
            return false;
        }
        return entryMBR.contains(rect.getMinCoords(), this.tolerance);
    }

    public boolean conditionFulfilled(MBR rect, SpatialSearchTreeEntry entry) {
        if (rect == null || entry == null) {
            return false;
        }
        return entry.getMBR().contains(rect.getMinCoords(), this.tolerance);
    }

    public boolean conditionFulfilled(MBR rect, SpatialSearchTreeObject obj) {
        VisualizedSpatialSearchTreeObject vObj = (VisualizedSpatialSearchTreeObject)obj;
        if (rect == null || obj == null) {
            return false;
        }
        return vObj.interacts(rect.min(0), rect.min(1), Math.round(this.scale));
    }
}

