/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import java.awt.Color;
import java.awt.Graphics;
import java.util.BitSet;
import spatial.MBR;
import spatial.MemoryRTree;
import spatial.MovingSpatialSearchTreeObject;
import spatial.SpatialSearchTree;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeNode;
import spatial.SpatialSearchTreeObject;

public class MemoryRTreeNode
implements SpatialSearchTreeNode {
    protected static int MAXENTRYNUM = 16;
    protected MemoryRTree tree;
    protected MBR mbr = null;
    protected SpatialSearchTreeEntry[] entry = new SpatialSearchTreeEntry[MAXENTRYNUM + 1];
    protected int num = 0;
    protected boolean isLeaf = false;
    protected boolean isRoot = false;

    protected MemoryRTreeNode(MemoryRTree tree) {
        this.mbr = new MBR(tree.dim);
        this.isLeaf = true;
        this.isRoot = true;
        this.tree = tree;
    }

    protected MemoryRTreeNode(MemoryRTreeNode subtree1, MemoryRTreeNode subtree2) {
        this.entry[0] = subtree1;
        this.entry[1] = subtree2;
        this.num = 2;
        this.mbr = subtree1.getMBR().union(subtree2.getMBR());
        this.tree = subtree1.tree;
        this.tree.root = this;
    }

    protected MemoryRTreeNode(boolean isLeaf, MemoryRTree tree) {
        this.mbr = new MBR(tree.dim);
        this.isLeaf = isLeaf;
        this.isRoot = false;
        this.tree = tree;
    }

    protected void adaptMBR() {
        if (this.num > 0) {
            this.mbr.setBounds(this.entry[0].getMBR());
            int i = 1;
            while (i < this.num) {
                this.mbr.add(this.entry[i].getMBR());
                ++i;
            }
        }
    }

    public int computeNumberOfEntries() {
        if (this.isLeaf) {
            return this.num;
        }
        int n = this.num;
        int i = 0;
        while (i < this.num) {
            n += ((MemoryRTreeNode)this.entry[i]).computeNumberOfEntries();
            ++i;
        }
        return n;
    }

    public int computeNumberOfNodes() {
        if (this.isLeaf) {
            return 1;
        }
        int n = 1;
        int i = 0;
        while (i < this.num) {
            n += ((MemoryRTreeNode)this.entry[i]).computeNumberOfNodes();
            ++i;
        }
        return n;
    }

    protected void debugPrint(int height, boolean traverse) {
        System.out.println("============ " + height);
        int i = 0;
        while (i < this.num) {
            if (this.entry[i].getMBR() == null) {
                System.out.println("null");
            } else {
                System.out.println(this.entry[i].getMBR().toString());
            }
            if (!this.isLeaf() && traverse) {
                ((MemoryRTreeNode)this.entry[i]).debugPrint(height + 1, true);
            }
            ++i;
        }
        System.out.println("============ " + (height + 1));
    }

    protected void draw(int actHeight, Graphics g, int scale, int minHeight, int maxHeight) {
        if (actHeight == 0) {
            g.setColor(Color.black);
        } else if (actHeight == 1) {
            g.setColor(Color.blue);
        } else if (actHeight == 2) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.orange);
        }
        if (this.mbr != null && actHeight >= minHeight) {
            g.drawRect(this.mbr.min(0) / scale, this.mbr.min(1) / scale, this.mbr.extension(0) / scale, this.mbr.extension(1) / scale);
        }
        if (!this.isLeaf && actHeight < maxHeight) {
            int i = 0;
            while (i < this.num) {
                MemoryRTreeNode subtree = (MemoryRTreeNode)this.entry[i];
                subtree.draw(actHeight + 1, g, scale, minHeight, maxHeight);
                ++i;
            }
        }
    }

    public SpatialSearchTreeNode getChildNode(int index) {
        if (!this.isLeaf && index >= 0 && index < this.num) {
            return (SpatialSearchTreeNode)this.entry[index];
        }
        return null;
    }

    public SpatialSearchTreeEntry getEntry(int index) {
        if (index >= 0 && index < this.num) {
            return this.entry[index];
        }
        return null;
    }

    public MBR getEntryMBR(int index) {
        if (index >= 0 && index < this.num) {
            return this.entry[index].getMBR();
        }
        return null;
    }

    public int getHeight() {
        if (this.isLeaf) {
            return 1;
        }
        return ((MemoryRTreeNode)this.entry[0]).getHeight() + 1;
    }

    public int getMaxNumberOfEntries() {
        return MAXENTRYNUM;
    }

    public MBR getMBR() {
        return this.mbr;
    }

    public int getNumOfDimensions() {
        return this.mbr.numOfDimensions();
    }

    public int getNumberOfEntries() {
        return this.num;
    }

    public SpatialSearchTreeObject getObject(int index) {
        if (this.isLeaf && index >= 0 && index < this.num) {
            return (SpatialSearchTreeObject)this.entry[index];
        }
        return null;
    }

    public SpatialSearchTree getTree() {
        return this.tree;
    }

    public MemoryRTreeNode insert(SpatialSearchTreeObject obj) {
        if (this.num == 0) {
            this.mbr.setBounds(obj.getMBR());
        } else {
            this.mbr.add(obj.getMBR());
        }
        if (this.isLeaf) {
            if (this.num < 0 || this.num > MAXENTRYNUM) {
                System.err.println("num falsch (1) !!!");
            }
            this.entry[this.num] = obj;
            ++this.num;
            ++this.tree.totalnum;
        } else {
            int index = this.tree.strategy.chooseSubtree(this, obj);
            MemoryRTreeNode subtree = (MemoryRTreeNode)this.entry[index];
            MemoryRTreeNode newEntry = subtree.insert(obj);
            if (newEntry != null) {
                if (this.num < 0 || this.num > MAXENTRYNUM) {
                    System.err.println("num falsch (2) !!!");
                }
                if (this.tree.strategy.isOrdering()) {
                    int i = this.num - 1;
                    while (i > index) {
                        this.entry[i + 1] = this.entry[i];
                        --i;
                    }
                    this.entry[index + 1] = newEntry;
                } else {
                    this.entry[this.num] = newEntry;
                }
                ++this.num;
            }
        }
        if (this.num <= MAXENTRYNUM) {
            if (this.isRoot) {
                return this;
            }
            return null;
        }
        MemoryRTreeNode newSubtree = this.split();
        if (this.isRoot) {
            MemoryRTreeNode newRoot = new MemoryRTreeNode(this, newSubtree);
            newRoot.isRoot = true;
            this.isRoot = false;
            return newRoot;
        }
        return newSubtree;
    }

    protected void insertSimple(SpatialSearchTreeEntry obj) {
        if (this.num == 0) {
            this.mbr.setBounds(obj.getMBR());
        } else {
            this.mbr.add(obj.getMBR());
        }
        this.entry[this.num] = obj;
        ++this.num;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean move(int index, MBR newMBR) {
        if (this.isLeaf && index >= 0 && index < this.num) {
            if (this.mbr.contains(newMBR)) {
                return false;
            }
            SpatialSearchTreeObject obj = (SpatialSearchTreeObject)this.entry[index];
            this.removeObject(index);
            ((MovingSpatialSearchTreeObject)obj).setMBR(newMBR);
            this.tree.root.insert(obj);
            return true;
        }
        return false;
    }

    public boolean pointsToLeaf() {
        if (this.isLeaf || this.num == 0) {
            return false;
        }
        MemoryRTreeNode subtree = (MemoryRTreeNode)this.entry[0];
        return subtree.isLeaf();
    }

    public void removeObject(int index) {
        if (this.isLeaf && index >= 0 && index < this.num) {
            --this.num;
            this.entry[index] = this.entry[this.num];
            this.entry[this.num] = null;
            --this.tree.totalnum;
            this.adaptMBR();
        }
    }

    public void resetLock() {
    }

    public void setEntry(SpatialSearchTreeEntry entry, int i) {
        if (i >= 0 && i < this.num) {
            this.entry[i] = entry;
        }
    }

    public void setLock() {
    }

    public static void setMaximumCapacity(int capacity) {
        MAXENTRYNUM = capacity;
    }

    protected MemoryRTreeNode split() {
        MemoryRTreeEntry parentEntry = new MemoryRTreeEntry(this.mbr);
        BitSet indicator = this.tree.strategy.distribute(this, parentEntry);
        MemoryRTreeNode newNode = new MemoryRTreeNode(this.isLeaf, this.tree);
        int i = 0;
        while (i < this.num) {
            if (indicator.get(i)) {
                newNode.insertSimple(this.entry[i]);
            }
            ++i;
        }
        int oldNum = this.num;
        this.num = 0;
        int i2 = 0;
        while (i2 < oldNum) {
            if (!indicator.get(i2)) {
                this.insertSimple(this.entry[i2]);
            }
            ++i2;
        }
        if (this.num <= 0 || this.num > MAXENTRYNUM) {
            System.err.println("split - Fehler: " + this.num + " + " + newNode.getNumberOfEntries());
        }
        return newNode;
    }

    public void updateObject(int index) {
    }

    protected class MemoryRTreeEntry
    implements SpatialSearchTreeEntry {
        protected MBR mbr;

        protected MemoryRTreeEntry(MBR mbr) {
            this.mbr = mbr;
        }

        public MBR getMBR() {
            return this.mbr;
        }

        public int getNumOfDimensions() {
            return this.mbr.numOfDimensions();
        }
    }
}

