/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import java.awt.Graphics;
import java.awt.Rectangle;
import spatial.IsContainedQuery;
import spatial.MemoryRTreeNode;
import spatial.RTreeStrategy;
import spatial.RegionQuery;
import spatial.SimpleRTreeStrategy;
import spatial.SpatialSearchTree;
import spatial.SpatialSearchTreeNode;
import spatial.SpatialSearchTreeObject;

public class MemoryRTree
implements SpatialSearchTree {
    protected int dim = 2;
    protected RTreeStrategy strategy = new SimpleRTreeStrategy();
    protected MemoryRTreeNode root = null;
    protected int totalnum = 0;
    protected RegionQuery removeQuery;
    protected RegionQuery moveQuery;

    public MemoryRTree() {
        this.removeQuery = new RegionQuery(new IsContainedQuery());
        this.moveQuery = new RegionQuery(new IsContainedQuery());
        this.root = new MemoryRTreeNode(this);
    }

    public MemoryRTree(int dim, int nodecapacity) {
        this.dim = dim;
        MemoryRTreeNode.setMaximumCapacity(nodecapacity);
        this.removeQuery = new RegionQuery(new IsContainedQuery());
        this.moveQuery = new RegionQuery(new IsContainedQuery());
        this.root = new MemoryRTreeNode(this);
    }

    public void close() {
    }

    public int computeNumberOfEntries() {
        return this.root.computeNumberOfEntries();
    }

    public int computeNumberOfNodes() {
        return this.root.computeNumberOfNodes();
    }

    public void debugPrint() {
        this.root.debugPrint(1, true);
    }

    public void draw(Graphics g, Rectangle clip, int scale, int minHeight, int maxHeight) {
        this.root.draw(0, g, scale, minHeight, maxHeight);
        System.out.println("Info: " + this.getHeight() + "/" + this.computeNumberOfNodes() + "/" + this.computeNumberOfEntries() + "/" + this.totalnum);
    }

    public int getHeight() {
        return this.root.getHeight();
    }

    public int getNumOfDimensions() {
        return this.dim;
    }

    public SpatialSearchTreeNode getRoot() {
        return this.root;
    }

    public int getTotalNumberOfObjects() {
        return this.totalnum;
    }

    public void insert(SpatialSearchTreeObject obj) {
        this.root = this.root.insert(obj);
    }

    public boolean remove(SpatialSearchTreeObject obj) {
        if (obj == null) {
            return false;
        }
        this.removeQuery.initWithObject(this, obj, 1);
        SpatialSearchTreeObject found = this.removeQuery.getNextObject();
        return found != null;
    }

    public void setSplitStrategy(RTreeStrategy str) {
        this.strategy = str;
    }
}

