/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.DrawableObjects;
import drawables.DrawableObjectsWithSearchTree;
import drawables.DrawablePresentation;
import drawables.DrawableSpatialSearchTreeObject;
import java.awt.Color;
import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import routing.Edges;
import routing.Node;

public class Nodes {
    private Hashtable hashTable = null;
    private DrawableObjects objects = null;
    private long maxId = 0L;
    private int numOfClasses = 0;
    private int actEdge = 0;
    protected int nullMark = 0;
    protected int maxMark = 0;
    private Node searchNode = new Node(0L, 0, 0);
    protected int[] minScale = new int[]{16, 8, 4, 2, 1, 1, 1, 1};
    protected int[] minTextScale = new int[]{8, 4, 2, 1, 1, 1, 1, 1};

    public Nodes(int numOfClasses) {
        this.numOfClasses = numOfClasses;
        this.hashTable = new Hashtable(10000);
    }

    public Nodes(Edges edges) {
        this.numOfClasses = edges.getNumOfClasses() + 1;
        this.hashTable = new Hashtable(10000);
    }

    public void clearAllMarks() {
        ++this.maxMark;
        this.nullMark = this.maxMark;
    }

    public Enumeration elements() {
        return this.hashTable.elements();
    }

    public Node findNearest(int x, int y) {
        if (this.numOfNodes() == 0) {
            return null;
        }
        Enumeration e = null;
        Node node = null;
        if (this.objects == null) {
            e = this.hashTable.elements();
            node = (Node)e.nextElement();
            this.objects = node.getContainer();
        }
        Node testNode = new Node(0L, x, y);
        if (this.objects != null) {
            try {
                return (Node)((DrawableObjectsWithSearchTree)this.objects).findNearestDrawable(x, y, null, new DrawableSpatialSearchTreeObject(testNode));
            }
            catch (Exception ex) {
                System.err.println("Exception in Nodes.findNearest: " + ex);
            }
        }
        Node nearestNode = node;
        double distance = testNode.distanceTo(nearestNode);
        while (e.hasMoreElements()) {
            Node next = (Node)e.nextElement();
            double actDist = testNode.distanceTo(next);
            if (!(actDist < distance)) continue;
            nearestNode = next;
            distance = actDist;
        }
        return nearestNode;
    }

    public Node get(long id) {
        this.searchNode.setID(id);
        return (Node)this.hashTable.get(this.searchNode);
    }

    public long getNextFreeId() {
        return this.maxId + 1L;
    }

    public int getNumOfClasses() {
        return this.numOfClasses;
    }

    public void initPresentation(Color[] color, Color highlightColor) {
        int i = 0;
        while (i < this.numOfClasses) {
            DrawablePresentation.newDrawablePresentation("Node" + i, true, Color.black, color[i], Color.black, highlightColor, 1, 6);
            DrawablePresentation.newDrawablePresentation("NodeText" + i, true, Color.black, highlightColor, 0, 7, 6, 65535, 0);
            ++i;
        }
        DrawablePresentation.newDrawablePresentation("NodeH", true, Color.black, highlightColor, Color.black, highlightColor, 1, 6);
    }

    public Node newNode(long id, int x, int y, String name) {
        Node node = name != null ? new Node(id, x, y, name, this) : new Node(id, x, y, this);
        this.hashTable.put(node, node);
        if (id > this.maxId) {
            this.maxId = id;
        }
        return node;
    }

    public int numOfNodes() {
        return this.hashTable.size();
    }

    public Node read(DataInput in) {
        Node res = null;
        try {
            byte len = in.readByte();
            if (len > 0) {
                byte[] data = new byte[len];
                in.readFully(data);
                long pID = in.readLong();
                int x = in.readInt();
                int y = in.readInt();
                res = this.newNode(pID, x, y, new String(data));
            } else {
                long pID = in.readLong();
                int x = in.readInt();
                int y = in.readInt();
                res = this.newNode(pID, x, y, null);
            }
            return res;
        }
        catch (IOException e) {
            return res;
        }
    }

    public boolean removeNode(Node node) {
        if (node != null && node.getNumOfEdges() == 0) {
            this.hashTable.remove(node);
            return true;
        }
        return false;
    }

    public void setMinScaleArray(int[] newMinScale) {
        this.minScale = newMinScale;
    }

    public void setMinTextScaleArray(int[] newMinTextScale) {
        this.minTextScale = newMinTextScale;
    }

    public void setNumOfClasses(int num) {
        this.numOfClasses = num;
    }
}

