/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.DrawableObjectType;
import drawables.DrawableObjects;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipInputStream;
import routing.BorderHeap;
import routing.Edge;
import routing.Edges;
import routing.Node;
import routing.Nodes;
import routing.PathEdge;
import routing.StandardWeightManager;
import util.EntryWriter;

public class Network {
    protected Nodes nodes = null;
    protected Edges edges = null;
    private BorderHeap border = new BorderHeap();
    private static final double maxDistance = Double.MAX_VALUE;
    private static final int NWAY1 = 1;
    private static final int NWAY2 = 2;
    private static final int WAY = 1;
    private int WAY1 = 1;
    private int WAY2 = 2;
    private int FINAL = 4;
    private final int BEST = 8;

    public Network() {
        this.edges = new Edges();
        this.edges.setWeightManager(new StandardWeightManager(this.edges));
        this.nodes = new Nodes(this.edges);
    }

    public PathEdge computeFastestWay(Node start, Node stop) {
        if (start == null || stop == null || start.equals(stop)) {
            return null;
        }
        this.nodes.clearAllMarks();
        start.clearWays();
        start.mark(this.FINAL);
        start.mark(8);
        start.setDistanceOfWay(1, 0.0);
        this.border.reset();
        this.enlargeBorder(this.border, start, stop, 1, false);
        boolean elementFound = this.border.fetchFirst();
        Node actNode = null;
        while (elementFound && !stop.equals(actNode = this.border.returnNode())) {
            actNode.mark(1);
            this.enlargeBorder(this.border, actNode, stop, 1, false);
            elementFound = this.border.fetchFirst();
        }
        return this.computeResultPath(actNode, false);
    }

    public PathEdge computeFastWay(Node start, Node stop) {
        if (start == null || stop == null || start.equals(stop)) {
            return null;
        }
        this.nodes.clearAllMarks();
        start.clearWays();
        start.mark(this.FINAL);
        start.mark(8);
        start.setDistanceOfWay(1, 0.0);
        this.border.reset();
        this.enlargeBorder(this.border, start, stop, 1, true);
        boolean elementFound = this.border.fetchFirst();
        Node actNode = null;
        while (elementFound && !stop.equals(actNode = this.border.returnNode())) {
            actNode.mark(this.FINAL);
            this.enlargeBorder(this.border, actNode, stop, 1, true);
            elementFound = this.border.fetchFirst();
        }
        return this.computeResultPath(actNode, false);
    }

    public PathEdge computeFastWay2(Node start, Node stop) {
        if (start == null || stop == null || start.equals(stop)) {
            return null;
        }
        this.nodes.clearAllMarks();
        start.clearWays();
        start.mark(this.WAY1);
        start.setDistanceOfWay(this.WAY1, 0.0);
        stop.clearWays();
        stop.mark(this.WAY2);
        stop.setDistanceOfWay(this.WAY2, 0.0);
        this.border.reset();
        this.enlargeBorder(this.border, start, stop, this.WAY1, true);
        this.enlargeBorder(this.border, stop, start, this.WAY2, true);
        boolean elementFound = this.border.fetchFirst();
        Node actNode = null;
        while (elementFound) {
            actNode = this.border.returnNode();
            if (actNode.isMarked(this.WAY1)) {
                actNode.mark(this.FINAL);
                if (actNode.isMarked(this.WAY2)) break;
                this.enlargeBorder(this.border, actNode, stop, this.WAY1, true);
            } else if (actNode.isMarked(this.WAY2)) {
                actNode.mark(this.FINAL);
                this.enlargeBorder(this.border, actNode, start, this.WAY2, true);
            } else {
                System.err.println("Fehler: Knoten falsch markiert!");
            }
            elementFound = this.border.fetchFirst();
        }
        PathEdge res = this.computeResultPath(actNode, true);
        if (res == null) {
            return null;
        }
        if (res.getStartingNode() != start) {
            res = this.computeFastWay(start, stop);
            if (res == null) {
                return null;
            }
            if (res.getStartingNode() != start) {
                return null;
            }
        }
        return res;
    }

    public PathEdge computeFastWays(Node start, Node stop, int threshold) {
        if (start == null || stop == null || start.equals(stop)) {
            return null;
        }
        this.border.reset();
        PathEdge resPath = null;
        double shortestDistance = Double.MAX_VALUE;
        this.nodes.clearAllMarks();
        start.clearWays();
        start.mark(this.WAY1);
        start.setDistanceOfWay(1, 0.0);
        stop.clearWays();
        stop.mark(this.WAY2);
        stop.setDistanceOfWay(2, 0.0);
        int numOfLoops = 1;
        while (true) {
            System.out.println("** Durchlauf " + numOfLoops + " **");
            this.enlargeBorder(this.border, start, stop, this.WAY1, threshold, shortestDistance, resPath);
            this.enlargeBorder(this.border, stop, start, this.WAY2, threshold, shortestDistance, resPath);
            boolean elementFound = this.border.fetchFirst();
            while (elementFound) {
                if (this.border.returnDistance() * 100.0 / (double)(100 + threshold) > shortestDistance) break;
                Node actNode = this.border.returnNode();
                actNode.mark(this.FINAL);
                if (actNode.isMarked(this.WAY1)) {
                    if (numOfLoops != 1 || !actNode.isMarked(8)) {
                        if (actNode.isMarked(this.WAY2)) {
                            if (numOfLoops == 1) {
                                if (resPath == null) {
                                    resPath = this.computeResultPath(actNode, true);
                                    if (resPath == null) {
                                        return null;
                                    }
                                    shortestDistance = actNode.getDistanceOfWay(1) + actNode.getDistanceOfWay(2);
                                } else if ((actNode.getDistanceOfWay(1) + actNode.getDistanceOfWay(2)) * 100.0 / (double)(100 + threshold) <= shortestDistance) {
                                    resPath.addPath(this.computeResultPath(actNode, true));
                                    if (actNode.getDistanceOfWay(1) + actNode.getDistanceOfWay(2) < shortestDistance) {
                                        shortestDistance = actNode.getDistanceOfWay(1) + actNode.getDistanceOfWay(2);
                                    }
                                }
                            }
                        } else {
                            this.enlargeBorder(this.border, actNode, stop, this.WAY1, threshold, shortestDistance, resPath);
                        }
                    }
                } else if (actNode.isMarked(this.WAY2)) {
                    this.enlargeBorder(this.border, actNode, start, this.WAY2, threshold, shortestDistance, resPath);
                } else {
                    actNode.debugPrint(this.WAY1);
                    actNode.debugPrint(this.WAY2);
                    System.err.println(" ist falsch markiert!");
                }
                elementFound = this.border.fetchFirst();
                while (elementFound && actNode.equals(this.border.returnNode())) {
                    elementFound = this.border.fetchFirst();
                }
            }
            if (numOfLoops == 2) break;
            this.WAY1 = 16;
            this.WAY2 = this.WAY1 * 2;
            this.FINAL = this.WAY2 * 2;
            start.mark(this.WAY1);
            stop.mark(this.WAY2);
            this.border.reset();
            ++numOfLoops;
        }
        this.WAY1 = 1;
        this.WAY2 = 2;
        this.FINAL = this.WAY2 * 2;
        return resPath;
    }

    protected void computeNewConnection(BorderHeap border, Node start, Edge actEdge, Node stop, int wayMark, int threshold, double shortestDistance, PathEdge resPath) {
        Node oppositeNode;
        int way = wayMark / this.WAY1;
        int theOtherWay = 1;
        if (way == 1) {
            theOtherWay = 2;
        }
        boolean bothBest = (oppositeNode = actEdge.getOppositeNode(start)).isMarked(8) && start.isMarked(8);
        long addDistance = 0L;
        while (!oppositeNode.isMarked(8)) {
            Edge nextEdge = oppositeNode.getWayEdge(way);
            if (nextEdge == null) break;
            addDistance = (long)((double)addDistance + nextEdge.getWeight());
            oppositeNode = oppositeNode.getWayEdge(way).getOppositeNode(oppositeNode);
        }
        Node searchNode = start;
        while (!searchNode.isMarked(8)) {
            Edge nextEdge = searchNode.getWayEdge(way);
            if (nextEdge == null) break;
            searchNode = searchNode.getWayEdge(way).getOppositeNode(searchNode);
        }
        if (bothBest) {
            boolean bl = bothBest = resPath.findEdge(actEdge) != null;
            if (!bothBest) {
                System.out.print("bothBest: ");
                searchNode.debugPrint(way);
                System.out.print(" -> ");
                oppositeNode.debugPrint(way);
                System.out.print(" bislang nicht in L\u00f6sung.");
                System.out.println();
            }
        }
        if (searchNode.getDistanceOfWay(way) < oppositeNode.getDistanceOfWay(way) && !bothBest) {
            double actWeight = actEdge.getWeight();
            if ((start.getDistanceOfWay(way) + actWeight + (double)addDistance + oppositeNode.getDistanceOfWay(theOtherWay)) * 100.0 / (double)(threshold + 100) <= shortestDistance) {
                if (addDistance > 0L) {
                    resPath.addPath(this.computeResultPathBackwards(actEdge.getOppositeNode(start), way));
                }
                resPath.addPath(this.computeResultPath(start, way, actEdge.getOppositeNode(start).getDistanceOfWay(theOtherWay) + actEdge.getWeight()));
                resPath.addPath(new PathEdge(actEdge, actEdge.isStartingFrom(start), actWeight));
            }
        }
    }

    protected PathEdge computeResultPath(Node actNode, int way, double distOfOtherWay) {
        if (actNode == null) {
            return null;
        }
        int theOtherWay = 1;
        if (theOtherWay == way) {
            theOtherWay = 2;
        }
        PathEdge path = null;
        Edge actEdge = actNode.getWayEdge(way);
        while (!actNode.isMarked(8) && actEdge != null) {
            actNode.mark(8);
            actNode.setDistanceOfWay(theOtherWay, distOfOtherWay);
            double actWeight = actEdge.getWeight(actEdge.isDirectedTo(actNode));
            path = new PathEdge(actEdge, actEdge.isDirectedTo(actNode), actWeight, path);
            distOfOtherWay += actWeight;
            actNode = actEdge.getOppositeNode(actNode);
            actEdge = actNode.getWayEdge(way);
        }
        return path;
    }

    protected PathEdge computeResultPath(Node firstNode, boolean computeNWAY2) {
        if (firstNode == null) {
            return null;
        }
        firstNode.mark(8);
        double actDist = firstNode.getDistanceOfWay(2);
        PathEdge path = null;
        PathEdge firstPath = null;
        Node actNode = null;
        if (firstNode.getWayEdge(1) != null) {
            Edge actEdge = firstNode.getWayEdge(1);
            double actWeight = actEdge.getWeight(actEdge.isDirectedTo(firstNode));
            path = firstPath = new PathEdge(actEdge, actEdge.isDirectedTo(firstNode), actWeight);
            actDist += actWeight;
            actNode = actEdge.getOppositeNode(firstNode);
            while (!actNode.isMarked(8) && actNode.getWayEdge(1) != null) {
                actNode.mark(8);
                actNode.setDistanceOfWay(2, actDist);
                actEdge = actNode.getWayEdge(1);
                actWeight = actEdge.getWeight(actEdge.isDirectedTo(actNode));
                path = new PathEdge(actEdge, actEdge.isDirectedTo(actNode), actWeight, path);
                actDist += actWeight;
                actNode = actEdge.getOppositeNode(actNode);
            }
        }
        if (!computeNWAY2) {
            return path;
        }
        if (firstNode.getWayEdge(2) == null) {
            return path;
        }
        PathEdge resPath = null;
        Edge actEdge = firstNode.getWayEdge(2);
        double actWeight = actEdge.getWeight(actEdge.isStartingFrom(firstNode));
        if (path != null) {
            resPath = path;
            path = firstPath.next = new PathEdge(actEdge, actEdge.isStartingFrom(firstNode), actWeight);
        } else {
            resPath = path = new PathEdge(actEdge, actEdge.isStartingFrom(firstNode), actWeight);
        }
        actDist = firstNode.getDistanceOfWay(1) + actWeight;
        actNode = actEdge.getOppositeNode(firstNode);
        actEdge = actNode.getWayEdge(2);
        while (!actNode.isMarked(8) && actEdge != null) {
            actNode.mark(8);
            actNode.setDistanceOfWay(1, actDist);
            actWeight = actEdge.getWeight(actEdge.isStartingFrom(actNode));
            path = path.next = new PathEdge(actEdge, actEdge.isStartingFrom(actNode), actWeight);
            actDist += actWeight;
            actNode = actEdge.getOppositeNode(actNode);
            actEdge = actNode.getWayEdge(2);
        }
        return resPath;
    }

    protected PathEdge computeResultPathBackwards(Node firstNode, int way) {
        if (firstNode == null) {
            return null;
        }
        int theOtherWay = 1;
        if (theOtherWay == way) {
            theOtherWay = 2;
        }
        Node actNode = firstNode;
        PathEdge path = null;
        long distOfOtherWay = 0L;
        double distOfWay = actNode.getDistanceOfWay(way);
        Edge actEdge = actNode.getWayEdge(way);
        while (!actNode.isMarked(8) && actEdge != null) {
            actNode.mark(8);
            actNode.setDistanceOfWay(way, distOfWay);
            double actWeight = actEdge.getWeight(actEdge.isStartingFrom(actNode));
            path = new PathEdge(actEdge, actEdge.isStartingFrom(actNode), actWeight, path);
            distOfOtherWay = (long)((double)distOfOtherWay + actWeight);
            distOfWay += actWeight;
            actNode = actEdge.getOppositeNode(actNode);
            actEdge = actNode.getWayEdge(way);
        }
        distOfOtherWay = (long)((double)distOfOtherWay + actNode.getDistanceOfWay(theOtherWay));
        while (!firstNode.equals(actNode)) {
            firstNode.setDistanceOfWay(theOtherWay, distOfOtherWay);
            System.err.println("Ich glaube das nachfolgende ist falsch, da sich path nicht \u00e4ndert");
            distOfOtherWay = (long)((double)distOfOtherWay - path.edge.getWeight());
            firstNode = path.edge.getOppositeNode(firstNode);
        }
        return path;
    }

    public void createByNetworkFiles(DataInputStream nodeIn, DataInputStream edgeIn, DrawableObjects objects) {
        System.out.println("read nodes ...");
        DrawableObjectType nodeType = DrawableObjectType.getObjectType("Node");
        Node actNode = null;
        while ((actNode = this.nodes.read(nodeIn)) != null) {
            if (objects == null) continue;
            objects.addDrawable(actNode);
        }
        System.out.println("read edges ...");
        DrawableObjectType edgeType = DrawableObjectType.getObjectType("Edge");
        Edge actEdge = null;
        int line = 1;
        boolean eof = false;
        while (!eof) {
            try {
                actEdge = this.edges.read(edgeIn, this.nodes);
                if (actEdge != null) {
                    if (objects != null) {
                        objects.addDrawable(actEdge);
                    }
                } else {
                    System.err.println("Read error for edge on line " + line);
                }
                ++line;
            }
            catch (IOException ioe) {
                eof = true;
            }
        }
    }

    public boolean createByNetworkFiles(String filename, DrawableObjects objects) {
        try {
            DataInputStream nodeStream = new DataInputStream(new FileInputStream(String.valueOf(filename) + ".node"));
            DataInputStream edgeStream = new DataInputStream(new FileInputStream(String.valueOf(filename) + ".edge"));
            this.createByNetworkFiles(nodeStream, edgeStream, objects);
            return true;
        }
        catch (IOException e) {
            System.err.println("Network.create: I/O-Error!!!");
            return false;
        }
    }

    public void createByNetworkFiles(URL nodeURL, URL edgeURL, DrawableObjects objects) {
        try {
            ZipInputStream zis;
            DataInputStream nodeStream = null;
            DataInputStream edgeStream = null;
            if (nodeURL.toString().endsWith(".zip")) {
                zis = new ZipInputStream(nodeURL.openStream());
                zis.getNextEntry();
                nodeStream = new DataInputStream(zis);
            } else {
                nodeStream = new DataInputStream(nodeURL.openStream());
            }
            if (edgeURL.toString().endsWith(".zip")) {
                zis = new ZipInputStream(edgeURL.openStream());
                zis.getNextEntry();
                edgeStream = new DataInputStream(zis);
            } else {
                edgeStream = new DataInputStream(edgeURL.openStream());
            }
            this.createByNetworkFiles(nodeStream, edgeStream, objects);
        }
        catch (IOException ex) {
            System.err.println("Network.createByNetworkFiles: I/O-Error!!!\n" + ex);
        }
    }

    protected void enlargeBorder(BorderHeap border, Node start, Node stop, int wayMark, int threshold, double shortestDistance, PathEdge resPath) {
        int way = wayMark / this.WAY1;
        int theOtherWay = 1;
        if (way == 1) {
            theOtherWay = 2;
        }
        Edge actEdge = start.getFirstEdge();
        while (actEdge != null) {
            if (actEdge != start.getWayEdge(way)) {
                boolean newInBorder;
                Node oppositeNode = actEdge.getOppositeNode(start);
                boolean bl = newInBorder = !oppositeNode.isMarked(wayMark);
                if (newInBorder) {
                    oppositeNode.setDistanceOfWay(way, Double.MAX_VALUE);
                }
                if (!oppositeNode.isMarked(this.FINAL) && start.getDistanceOfWay(way) + actEdge.getWeight() <= oppositeNode.getDistanceOfWay(way)) {
                    oppositeNode.setDistanceOfWay(way, start.getDistanceOfWay(way) + actEdge.getWeight());
                    if (newInBorder) {
                        oppositeNode.setWay(way, actEdge);
                        oppositeNode.mark(wayMark);
                        border.insert(oppositeNode, way, this.edges.getWeightManager().computeWeight(oppositeNode.distanceTo(stop)));
                    } else {
                        if (oppositeNode.isMarked(8)) {
                            Edge oldEdge = oppositeNode.getWayEdge(way);
                            this.computeNewConnection(border, oldEdge.getOppositeNode(oppositeNode), oldEdge, stop, wayMark, threshold, shortestDistance, resPath);
                        }
                        oppositeNode.setWay(way, actEdge);
                    }
                } else if (resPath != null && (oppositeNode.isMarked(8) || oppositeNode.isMarked(this.FINAL)) && (!start.isMarked(8) || oppositeNode.isMarked(8) && start.getDistanceOfWay(way) < oppositeNode.getDistanceOfWay(way))) {
                    this.computeNewConnection(border, start, actEdge, stop, wayMark, threshold, shortestDistance, resPath);
                }
            }
            actEdge = start.getNextEdge();
        }
    }

    protected void enlargeBorder(BorderHeap border, Node start, Node stop, int way, boolean considerDistToDest) {
        Edge actEdge = start.getFirstEdge();
        while (actEdge != null) {
            Node oppositeNode = actEdge.getOppositeNode(start);
            if (!oppositeNode.isMarked(this.FINAL)) {
                boolean newInBorder;
                boolean bl = newInBorder = !oppositeNode.isMarked(way);
                if (newInBorder) {
                    oppositeNode.setDistanceOfWay(way, Double.MAX_VALUE);
                }
                double actWeight = actEdge.getWeight(start);
                if (start.getDistanceOfWay(way) + actWeight < oppositeNode.getDistanceOfWay(way)) {
                    if (newInBorder) {
                        oppositeNode.setDistanceOfWay(way, start.getDistanceOfWay(way) + actWeight);
                        oppositeNode.setWay(way, actEdge);
                        oppositeNode.mark(way);
                        if (considerDistToDest) {
                            border.insert(oppositeNode, way, this.edges.getWeightManager().computeWeight(oppositeNode.distanceTo(stop)));
                        } else {
                            border.insert(oppositeNode, way, 0.0);
                        }
                    } else {
                        oppositeNode.setDistanceOfWay(way, start.getDistanceOfWay(way) + actWeight);
                        oppositeNode.setWay(way, actEdge);
                        border.adaptToDecreasedDistance(oppositeNode, way);
                    }
                }
            }
            actEdge = start.getNextEdge();
        }
    }

    public Edges getEdges() {
        return this.edges;
    }

    public Nodes getNodes() {
        return this.nodes;
    }

    public void save(String filename) {
        try {
            System.out.println("write nodes ...");
            FileOutputStream out = new FileOutputStream(String.valueOf(filename) + ".node");
            DataOutputStream dOut = new DataOutputStream(out);
            Enumeration e = this.nodes.elements();
            while (e.hasMoreElements()) {
                ((Node)e.nextElement()).write(dOut);
            }
            dOut.close();
            out.close();
            System.out.println("write edges ...");
            out = new FileOutputStream(String.valueOf(filename) + ".edge");
            dOut = new DataOutputStream(out);
            e = this.edges.elements();
            while (e.hasMoreElements()) {
                ((Edge)e.nextElement()).write(dOut);
            }
            dOut.close();
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("Network.save: I/O-Error" + ioe.getMessage());
        }
    }

    public void saveAsText(String filename) {
        try {
            System.out.println("write nodes (text) ...");
            FileOutputStream out = new FileOutputStream(String.valueOf(filename) + "_node.txt");
            EntryWriter eOut = new EntryWriter(out);
            Enumeration e = this.nodes.elements();
            while (e.hasMoreElements()) {
                ((Node)e.nextElement()).write(eOut);
            }
            eOut.flush();
            out.close();
            System.out.println("write edges (text) ...");
            out = new FileOutputStream(String.valueOf(filename) + "_edge.txt");
            eOut = new EntryWriter(out);
            e = this.edges.elements();
            while (e.hasMoreElements()) {
                ((Edge)e.nextElement()).write(eOut);
            }
            eOut.flush();
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("Network.saveAsText: I/O-Error" + ioe.getMessage());
        }
    }
}

