/*
 * Decompiled with CFR 0.152.
 */
package routing;

import routing.Node;
import util.CPUTimer;

public class BorderHeap {
    private BorderElement[] elements = new BorderElement[2000];
    private BorderElement retElement = null;
    private int num = 0;
    public static CPUTimer fetchTimer = new CPUTimer();
    public static CPUTimer insertTimer = new CPUTimer();
    public static CPUTimer changeTimer = new CPUTimer();

    public void adaptToDecreasedDistance(Node node, int way) {
        changeTimer.start();
        short k = node.heapPos[way - 1];
        if (k < 1 || k > this.num) {
            System.err.println("adaptToDecreasedDistance: heapPos 0wrong!");
        } else {
            this.upheap(k);
        }
        changeTimer.stop();
    }

    private void downheap(int k) {
        if (k > this.num) {
            return;
        }
        BorderElement v = this.elements[k];
        double vValue = v.dist + v.node.getDistanceOfWay(v.way);
        while (k <= this.num / 2) {
            int j = k + k;
            BorderElement aj = this.elements[j];
            double ajValue = aj.dist + aj.node.getDistanceOfWay(aj.way);
            if (j < this.num) {
                BorderElement aj1 = this.elements[j + 1];
                double aj1Value = aj1.dist + aj1.node.getDistanceOfWay(aj1.way);
                if (ajValue > aj1Value) {
                    ++j;
                    aj = aj1;
                    ajValue = aj1Value;
                }
            }
            if (vValue <= ajValue) break;
            this.elements[k] = aj;
            this.setHeapPos(k);
            k = j;
        }
        this.elements[k] = v;
        this.setHeapPos(k);
    }

    public boolean fetchFirst() {
        if (this.num == 0) {
            return false;
        }
        fetchTimer.start();
        this.retElement = this.elements[1];
        this.elements[1] = this.elements[this.num];
        --this.num;
        this.downheap(1);
        fetchTimer.stop();
        return true;
    }

    public void insert(Node node, int way, double distance) {
        insertTimer.start();
        if (this.num + 1 == this.elements.length) {
            BorderElement[] newElements = new BorderElement[this.elements.length * 2];
            int i = 0;
            while (i < this.elements.length) {
                newElements[i] = this.elements[i];
                ++i;
            }
            this.elements = newElements;
        }
        ++this.num;
        this.elements[this.num] = new BorderElement(node, way, distance);
        this.upheap(this.num);
        insertTimer.stop();
    }

    public void reset() {
        int i = 0;
        while (i <= this.num) {
            this.elements[i] = null;
            ++i;
        }
        this.num = 0;
    }

    public double returnDistance() {
        return this.retElement.dist + this.retElement.node.getDistanceOfWay(this.retElement.way);
    }

    public Node returnNode() {
        return this.retElement.node;
    }

    public int returnWay() {
        return this.retElement.way;
    }

    private void setHeapPos(int k) {
        this.elements[k].node.heapPos[this.elements[k].way - 1] = (short)k;
    }

    private void upheap(int k) {
        BorderElement v = this.elements[k];
        double vValue = v.dist + v.node.getDistanceOfWay(v.way);
        while (k > 1) {
            BorderElement a = this.elements[k / 2];
            double aValue = a.dist + a.node.getDistanceOfWay(v.way);
            if (aValue <= vValue) break;
            this.elements[k] = this.elements[k / 2];
            this.setHeapPos(k);
            k /= 2;
        }
        this.elements[k] = v;
        this.setHeapPos(k);
    }

    private class BorderElement {
        protected Node node;
        protected int way;
        protected double dist;

        protected BorderElement(Node node, int way, double dist) {
            this.node = node;
            this.way = way;
            this.dist = dist;
        }
    }
}

