/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import drawables.DrawableObjects;
import drawables.DrawableRectangle;
import drawables.DrawableSymbol;
import generator2.RandomGenerator;
import java.awt.Rectangle;
import java.util.Properties;
import java.util.Random;

public class Reporter {
    public static final byte NEW_OBJECT = 0;
    public static final byte MOVE_OBJECT = 1;
    public static final byte DEL_OBJECT = 2;
    protected Properties properties = null;
    protected boolean visualize = false;
    public static final String VIZ = "VIZ";
    protected static final int SYMBOLLAYER = 4;
    protected DrawableObjects objects = null;
    protected int numOfPoints = 0;
    protected int numOfEdges = 0;
    protected Random random;

    public Reporter(Properties properties, DrawableObjects objects) {
        this.properties = properties;
        this.objects = objects;
        this.visualize = properties.getProperty(VIZ) != null;
        this.random = RandomGenerator.getForReport(properties);
    }

    public void close() {
    }

    public int getNumberOfReportedEdges() {
        return this.numOfEdges;
    }

    public int getNumberOfReportedPoints() {
        return this.numOfPoints;
    }

    public void removeReportedObjects() {
        if (this.visualize && this.objects != null) {
            this.objects.removeAllObjectsOfLayer(4);
        }
    }

    public void reportDisappearingExternalObject(int time, long id, int repNum, int objClass, Rectangle rect) {
    }

    public void reportDisappearingObject(double time, long id, int repNum, int objClass, int x, int y, double doneDist, int reportProbability) {
    }

    public void reportDouble(String text, double value) {
        System.out.println(String.valueOf(text) + value);
    }

    public void reportEdge(double time, long objId, int edgeRepNum, int objClass, long edgeId, int edgeClass, int x1, int y1, double speed, int x2, int y2, int reportProbability) {
    }

    public void reportInt(String text, long value) {
        System.out.println(String.valueOf(text) + value);
    }

    public void reportMovingExternalObject(int time, long id, int repNum, int objClass, Rectangle rect) {
        if (this.visualize && this.objects != null) {
            this.visualizeExternalObject(rect, objClass, time);
        }
    }

    public int reportMovingObject(int time, long id, int repNum, int objClass, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY, int reportProbability) {
        if (reportProbability == 0) {
            return repNum;
        }
        if (Math.abs(this.random.nextInt()) % 1000 >= reportProbability) {
            return repNum;
        }
        ++this.numOfPoints;
        ++repNum;
        if (this.visualize && this.objects != null) {
            this.visualizeMovingObject((int)x, (int)y, objClass, time);
        }
        return repNum;
    }

    public void reportNewExternalObject(int time, long id, int objClass, Rectangle rect) {
        if (this.visualize && this.objects != null) {
            this.visualizeExternalObject(rect, objClass, time);
        }
    }

    public int reportNewMovingObject(int time, long id, int objClass, int x, int y, double speed, int nextNodeX, int nextNodeY, int reportProbability) {
        int repNum = 0;
        if (reportProbability > 0) {
            ++this.numOfPoints;
            ++repNum;
            if (this.visualize && this.objects != null) {
                this.visualizeMovingObject(x, y, objClass, time);
            }
        }
        return repNum;
    }

    protected void visualizeExternalObject(Rectangle rect, int objClass, int time) {
        DrawableRectangle area = new DrawableRectangle(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, false, "Rectangle" + objClass + "-" + time);
        area.setLayer(4);
        this.objects.addDrawable(area);
    }

    protected void visualizeMovingObject(int x, int y, int objClass, int time) {
        DrawableSymbol symbol = new DrawableSymbol(x, y, "Point" + objClass + "-" + time);
        symbol.setLayer(4);
        this.objects.addDrawable(symbol);
    }
}

