/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import drawables.DrawableObjects;
import generator2.Reporter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class PositionReporter
extends Reporter {
    protected DataOutputStream dOut = null;
    protected PrintWriter pOut = null;

    public PositionReporter(Properties properties, DrawableObjects objects) {
        super(properties, objects);
        String name = properties.getProperty("outputFile");
        if (name != null) {
            try {
                if (name.endsWith(".mpf")) {
                    this.dOut = new DataOutputStream(new FileOutputStream(name));
                } else {
                    this.pOut = new PrintWriter(new FileOutputStream(name));
                }
            }
            catch (Exception ioe) {
                System.err.println("Error occured by creating the output file " + name);
            }
        }
    }

    public void close() {
        try {
            if (this.dOut != null) {
                this.dOut.close();
            }
            if (this.pOut != null) {
                this.pOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void print(PrintWriter out, String action, long id, int repNum, int objClass, int time, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY) {
        if (out == null) {
            return;
        }
        out.print(action);
        out.print('\t');
        out.print(id);
        out.print('\t');
        out.print(repNum);
        out.print('\t');
        out.print(objClass);
        out.print('\t');
        out.print(time);
        out.print('\t');
        out.print(x);
        out.print('\t');
        out.print(y);
        out.print('\t');
        out.print(speed);
        out.print('\t');
        out.print(nextNodeX);
        out.print('\t');
        out.println(nextNodeY);
    }

    protected static void print(DataOutputStream out, byte action, long id, int repNum, int objClass, int time, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY) {
        if (out == null) {
            return;
        }
        try {
            out.writeByte(action);
            out.writeLong(id);
            out.writeInt(repNum);
            out.writeInt(objClass);
            out.writeInt(time);
            out.writeDouble(x);
            out.writeDouble(y);
            out.writeDouble(speed);
            out.writeDouble(doneDist);
            out.writeInt(nextNodeX);
            out.writeInt(nextNodeY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reportDisappearingObject(double time, long id, int repNum, int objClass, int x, int y, double doneDist, int reportProbability) {
        if (reportProbability > 0) {
            if (this.pOut != null) {
                PositionReporter.print(this.pOut, "disappearpoint", id, repNum, objClass, (int)Math.ceil(time), (double)x, (double)y, 0.0, doneDist, x, y);
            }
            if (this.dOut != null) {
                PositionReporter.print(this.dOut, (byte)2, id, repNum, objClass, (int)Math.ceil(time), (double)x, (double)y, 0.0, doneDist, x, y);
            }
        }
    }

    public int reportMovingObject(int time, long id, int repNum, int objClass, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY, int reportProbability) {
        int newRepNum = super.reportMovingObject(time, id, repNum, objClass, x, y, speed, doneDist, nextNodeX, nextNodeY, reportProbability);
        if (repNum != newRepNum) {
            if (this.pOut != null) {
                PositionReporter.print(this.pOut, "point", id, newRepNum, objClass, time, x, y, speed, doneDist, nextNodeX, nextNodeY);
            }
            if (this.dOut != null) {
                PositionReporter.print(this.dOut, (byte)1, id, newRepNum, objClass, time, x, y, speed, doneDist, nextNodeX, nextNodeY);
            }
        }
        return newRepNum;
    }

    public int reportNewMovingObject(int time, long id, int objClass, int x, int y, double speed, int nextNodeX, int nextNodeY, int reportProbability) {
        int repNum = super.reportNewMovingObject(time, id, objClass, x, y, speed, nextNodeX, nextNodeY, reportProbability);
        if (repNum > 0) {
            if (this.pOut != null) {
                PositionReporter.print(this.pOut, "newpoint", id, repNum, objClass, time, (double)x, (double)y, speed, 0.0, nextNodeX, nextNodeY);
            }
            if (this.dOut != null) {
                PositionReporter.print(this.dOut, (byte)0, id, repNum, objClass, time, (double)x, (double)y, speed, 0.0, nextNodeX, nextNodeY);
            }
        }
        return repNum;
    }
}

