/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.MovingObject;
import generator2.ObjectClasses;
import generator2.ObjectGenerator;
import generator2.ReRoute;
import generator2.Reporter;
import generator2.WeightManagerForDataGenerator;
import java.util.Vector;
import routing.Network;

public class MovingObjects {
    private Vector objs = null;
    private WeightManagerForDataGenerator wm = null;
    private ObjectClasses objClasses = null;
    private Network net = null;
    private ObjectGenerator objGen = null;
    private Reporter reporter = null;
    private ReRoute reroute = null;
    private int num = 0;
    private int totalNum = 0;
    private int travNodes = 0;
    private int travDegree = 0;

    public MovingObjects(WeightManagerForDataGenerator wm, Network net, ObjectGenerator objGen, Reporter reporter, ReRoute reroute) {
        this.wm = wm;
        this.objClasses = wm.getObjectClasses();
        this.net = net;
        this.objGen = objGen;
        this.reporter = reporter;
        this.reroute = reroute;
        this.objs = new Vector(10000, 10000);
    }

    protected void add(MovingObject obj) {
        this.objs.addElement(obj);
        ++this.num;
        ++this.totalNum;
    }

    public Network getNetwork() {
        return this.net;
    }

    public ObjectClasses getObjectClasses() {
        return this.objClasses;
    }

    public ReRoute getReRoute() {
        return this.reroute;
    }

    public int getTotalDegreeOfTraversedNodes() {
        return this.travDegree;
    }

    public int getTotalNumberOfTraversedNodes() {
        return this.travNodes;
    }

    public int getTotalNumOfObjects() {
        return this.totalNum;
    }

    public WeightManagerForDataGenerator getWeightManager() {
        return this.wm;
    }

    public void incTraversedDegreeBy(int value) {
        this.travDegree += value;
    }

    public void incTraversedNodesBy(int value) {
        this.travNodes += value;
    }

    public void move(int time) {
        int i = this.num - 1;
        while (i >= 0) {
            MovingObject obj = (MovingObject)this.objs.elementAt(i);
            if (obj.move(time, this.reporter)) {
                obj.reportEnd(this.reporter);
                this.remove(i);
            }
            --i;
        }
    }

    public void remove(int index) {
        MovingObject obj = (MovingObject)this.objs.elementAt(index);
        if (this.objGen != null && obj != null) {
            this.objGen.reachDestination(obj);
        }
        this.objs.setElementAt(this.objs.elementAt(this.num - 1), index);
        this.objs.setElementAt(null, this.num - 1);
        --this.num;
        this.objs.setSize(this.num);
    }

    public void removeObjects() {
        int i = 0;
        while (i < this.num) {
            MovingObject obj = (MovingObject)this.objs.elementAt(i);
            obj.decreaseUsage(obj.getActPathEdge());
            obj.getActPathEdge().getEdge().decUsage();
            this.objs.setElementAt(null, i);
            ++i;
        }
        this.num = 0;
        this.objs.setSize(this.num);
    }
}

