/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.ExternalObject;
import generator2.ExternalObjectClasses;
import generator2.RandomGenerator;
import generator2.Time;
import java.util.Properties;
import java.util.Random;
import spatial.MBR;

public class ExternalObjectGenerator {
    protected static int currId = 0;
    protected Properties properties = null;
    protected Time time;
    protected DataSpace dataspace;
    protected ExternalObjectClasses classes;
    protected int numOfExtObjPerTime = 1;
    protected int numOfExtObjAtBeginning = 0;
    protected Random random;

    public ExternalObjectGenerator(Properties properties, Time time, DataSpace dataspace, ExternalObjectClasses classes, int numOfExtObjPerTime, int numOfExtObjAtBeginning) {
        this.properties = properties;
        this.time = time;
        this.dataspace = dataspace;
        this.classes = classes;
        this.random = RandomGenerator.get(properties);
        this.numOfExtObjPerTime = numOfExtObjPerTime;
        this.numOfExtObjAtBeginning = numOfExtObjAtBeginning;
    }

    public ExternalObject computeExternalObject(int time) {
        int objClass = this.classes.computeNewExternalObjectClass(time);
        int dx = this.dataspace.getMaxX() - this.dataspace.getMinX();
        int dy = this.dataspace.getMaxY() - this.dataspace.getMinY();
        int x = Math.abs(this.random.nextInt()) % (dx + 1) + this.dataspace.getMinX();
        int y = Math.abs(this.random.nextInt()) % (dy + 1) + this.dataspace.getMinY();
        int extX = Math.abs(this.random.nextInt()) % this.classes.getExtension(objClass, 0) + 1;
        int extY = Math.abs(this.random.nextInt()) % this.classes.getExtension(objClass, 1) + 1;
        return new ExternalObject(currId++, time, this.classes.getLifetime(objClass), objClass, x, y, extX, extY);
    }

    public MBR computeNewPositionAndSize(int time, ExternalObject obj) {
        MBR mbr = obj.getMBR();
        int[] delta = new int[]{(this.dataspace.getMaxX() - this.dataspace.getMinX()) / 500, (this.dataspace.getMaxY() - this.dataspace.getMinY()) / 500};
        MBR newMBR = (MBR)mbr.clone();
        newMBR.translate(delta);
        newMBR.grow(delta);
        return newMBR;
    }

    public boolean externalObjectsExist() {
        return this.numOfExtObjPerTime > 0 || this.numOfExtObjAtBeginning > 0;
    }

    public int numberOfNewObjects(int time) {
        if (Time.isFirstTimeStamp(time)) {
            return this.numOfExtObjAtBeginning;
        }
        return this.numOfExtObjPerTime;
    }
}

