/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.ExternalObjects;
import generator2.Reporter;
import java.awt.Graphics;
import java.awt.Rectangle;
import spatial.LayerSpatialSearchTreeObject;
import spatial.MBR;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeObject;
import util.Timer;

public class ExternalObject
implements LayerSpatialSearchTreeObject {
    private int id;
    private MBR area;
    private int objClass = 0;
    private int startTime = 0;
    private int deathTime = 0;
    private ExternalObjects container = null;

    public ExternalObject(int id, int time, int lifetime, int objClass, int x, int y, int width, int height) {
        this.area = new MBR(x, y, width, height);
        this.id = id;
        this.objClass = objClass;
        this.startTime = time;
        this.deathTime = time + lifetime;
    }

    public void addToContainer(ExternalObjects container) {
        if (container != null) {
            this.container = container;
            container.add(this);
        }
    }

    public double computeDistanceTo(int[] p) {
        return this.area.quadDistanceFromCenter(p);
    }

    public boolean contains(MBR rect) {
        return this.area.contains(rect);
    }

    public void draw(Graphics g, int scale) {
        if (!this.isVisible(scale)) {
            return;
        }
        g.setColor(this.container.getObjectClasses().getColor(this.objClass));
        Rectangle r = this.area.extractRectangle(0, 1);
        g.drawRect(r.x / scale, r.y / scale, r.width / scale + 1, r.height / scale + 1);
    }

    public long getId() {
        return this.id;
    }

    public int getLayer() {
        return 4;
    }

    public MBR getMBR() {
        return this.area;
    }

    public int getNumOfDimensions() {
        return 2;
    }

    public int getObjectClass() {
        return this.objClass;
    }

    public Object getType() {
        return new Integer(this.objClass);
    }

    public boolean interacts(int x, int y, int scale) {
        int[] point = new int[]{x, y};
        return this.area.contains(point, 1);
    }

    public boolean intersects(Object obj) {
        return this.getMBR().intersects(((ExternalObject)obj).getMBR());
    }

    public boolean intersects(MBR r) {
        return r.intersects(this.getMBR());
    }

    public boolean isAlive(int currTime) {
        return currTime < this.deathTime;
    }

    public boolean isContainedBy(MBR rect) {
        return rect.contains(this.getMBR());
    }

    public boolean isContainedBy(SpatialSearchTreeEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.isContainedBy(entry.getMBR());
    }

    public boolean isOfSameType(SpatialSearchTreeObject obj) {
        try {
            ExternalObject o = (ExternalObject)obj;
            return this.getType() == o.getType();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isVisible(double scale) {
        int actTime = this.container.getTime().getCurrTime();
        return actTime >= this.startTime && actTime < this.deathTime;
    }

    public boolean isVisible(int scale) {
        return this.isVisible((double)scale);
    }

    public void reportDeletedObject(Reporter reporter, int currTime) {
        Timer.stop(1);
        if (reporter != null) {
            reporter.reportDisappearingExternalObject(currTime, this.id, currTime - this.startTime + 1, this.objClass, this.area.extractRectangle(0, 1));
        }
        Timer.start(1);
    }

    public void reportMovingObject(Reporter reporter, int currTime) {
        Timer.stop(1);
        if (reporter != null) {
            reporter.reportMovingExternalObject(currTime, this.id, currTime - this.startTime + 1, this.objClass, this.area.extractRectangle(0, 1));
        }
        Timer.start(1);
    }

    public void reportNewObject(Reporter reporter) {
        Timer.stop(1);
        if (reporter != null) {
            reporter.reportNewExternalObject(this.startTime, this.id, this.objClass, this.area.extractRectangle(0, 1));
        }
        Timer.start(1);
    }

    public void setMBR(MBR newMBR) {
        this.area = newMBR;
    }
}

