/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.Time;
import java.awt.Color;
import java.util.Properties;

public class EdgeClasses {
    protected Properties properties = null;
    protected Time time = null;
    protected int num = 0;
    protected int maxSpeedDivisor = 1;
    protected int[] maxSpeed = null;
    protected int[] capacity = null;
    protected int[] minScale = null;
    protected Color[] color = null;

    public EdgeClasses(Properties properties) {
        this.properties = properties;
        this.num = 8;
        this.maxSpeed = new int[this.num];
        this.capacity = new int[this.num];
        this.capacity[0] = 5;
        this.capacity[1] = 5;
        this.capacity[2] = 4;
        this.capacity[3] = 4;
        this.capacity[4] = 3;
        this.capacity[5] = 3;
        this.capacity[6] = 2;
        this.capacity[7] = 2;
        this.minScale = new int[this.num];
        this.minScale[0] = 327680;
        this.minScale[1] = 81920;
        this.minScale[2] = 10240;
        this.minScale[3] = 1280;
        this.minScale[4] = 320;
        this.minScale[5] = 160;
        this.minScale[6] = 80;
        this.minScale[7] = 80;
        this.color = new Color[this.num];
        this.color[0] = Color.blue;
        this.color[1] = Color.red;
        this.color[2] = Color.orange;
        this.color[3] = Color.gray;
        this.color[4] = Color.cyan;
        this.color[5] = Color.green;
        this.color[6] = Color.lightGray;
        this.color[7] = Color.lightGray;
    }

    public void announce(Time time, DataSpace ds, int maxSpeedDivisor) {
        this.time = time;
        this.maxSpeedDivisor = maxSpeedDivisor;
        int dist = ds.getMaxX() - ds.getMinX() + ds.getMaxY() - ds.getMinY();
        this.maxSpeed[0] = dist / maxSpeedDivisor;
        int i = 1;
        while (i < this.num) {
            this.maxSpeed[i] = 2 * this.maxSpeed[i - 1] / 3;
            ++i;
        }
    }

    public int deceleratedSpeed(int c, int edgeUsage) {
        return this.maxSpeed[c];
    }

    public int getCapacity(int c) {
        if (c >= 0 && c < this.num) {
            return this.capacity[c];
        }
        return 0;
    }

    public Color getColor(int c) {
        if (c >= 0 && c < this.num) {
            return this.color[c];
        }
        return Color.gray;
    }

    public int getMaxSpeed(int c) {
        if (c >= 0 && c < this.num) {
            return this.maxSpeed[c];
        }
        return 0;
    }

    public int getMaxSpeedDivisor() {
        return this.maxSpeedDivisor;
    }

    public int getMinScale(int c) {
        if (c >= 0 && c < this.num) {
            return this.minScale[c];
        }
        return 0;
    }

    public int getNumber() {
        return this.num;
    }
}

