/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.DrawablePresentation;
import drawables.FilledDrawable;
import java.awt.Graphics;
import java.awt.Rectangle;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableRectangle
extends FilledDrawable {
    public DrawableRectangle() {
    }

    public DrawableRectangle(int x1, int y1, int x2, int y2) {
        this.mbr = new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        this.pres = DrawablePresentation.get("default");
    }

    public DrawableRectangle(int x1, int y1, int x2, int y2, boolean pFilled, String presName) {
        this(x1, y1, x2, y2);
        this.filled = pFilled;
        if (this.filled) {
            this.layer = 0;
        }
        this.pres = DrawablePresentation.get(presName);
    }

    public DrawableRectangle(int x1, int y1, int x2, int y2, boolean pFilled, String presName, int pMinScale, int pMaxScale) {
        this(x1, y1, x2, y2, pFilled, presName);
        this.minScale = pMinScale;
        this.maxScale = pMaxScale;
    }

    public DrawableRectangle(Rectangle rect) {
        this.mbr = new Rectangle(rect);
        this.pres = DrawablePresentation.get("default");
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        if (this.filled && this.selected && ap.selectionFillColor != null) {
            g.setColor(ap.selectionFillColor);
            g.fillRect(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
        if (this.filled && !this.selected && ap.fillColor != null) {
            g.setColor(ap.fillColor);
            g.fillRect(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
        if (this.selected && ap.selectionColor != null) {
            g.setColor(ap.selectionColor);
            g.drawRect(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        } else if (ap.color != null) {
            g.setColor(ap.color);
            g.drawRect(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        int x1 = r.readInt();
        int y1 = r.readInt();
        int x2 = r.readInt();
        int y2 = r.readInt();
        this.mbr = new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        if (type == 0) {
            this.pres = DrawablePresentation.get("default");
            return this;
        }
        int f = r.readInt();
        this.filled = f != 0;
        this.pres = DrawablePresentation.get(r.readString());
        if (this.filled) {
            this.layer = 0;
        }
        if (type == 1) {
            return this;
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        return this;
    }

    protected void writeProtected(EntryWriter out, int type) {
        out.print("Rectangle\t" + type + '\t');
        int x2 = this.mbr.x + this.mbr.width / 2;
        int y2 = this.mbr.y + this.mbr.height / 2;
        out.print(this.mbr.x);
        out.print('\t');
        out.print(this.mbr.y);
        out.print('\t');
        out.print(x2);
        out.print('\t');
        out.print(y2);
        out.print('\t');
        if (type == 0) {
            return;
        }
        if (this.filled) {
            out.print("1\t");
        } else {
            out.print("0\t");
        }
        out.print(String.valueOf(this.pres.getName()) + '\t');
        if (type == 1) {
            return;
        }
        out.print(this.minScale);
        out.print('\t');
        out.print(this.maxScale);
        out.print('\t');
    }
}

