/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.DrawableLine;
import drawables.DrawablePolygon;
import drawables.DrawablePresentation;
import java.awt.Color;
import java.awt.Graphics;
import util.EntryWriter;

public class DrawablePolyline
extends DrawablePolygon {
    protected DrawablePolyline() {
        this.pres = DrawablePresentation.get("default");
    }

    public DrawablePolyline(int[] xpoints, int[] ypoints, int npoints, String presName) {
        this(npoints, xpoints, ypoints, presName);
    }

    public DrawablePolyline(int npoints, int[] xpoints, int[] ypoints) {
        super(npoints, xpoints, ypoints);
    }

    public DrawablePolyline(int npoints, int[] xpoints, int[] ypoints, String presName) {
        super(npoints, xpoints, ypoints, false, presName);
    }

    public DrawablePolyline(int npoints, int[] xpoints, int[] ypoints, String presName, int minScale, int maxScale) {
        super(npoints, xpoints, ypoints, false, presName, minScale, maxScale);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        Color c;
        if (this.num == 0) {
            return;
        }
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        Color color = c = this.selected ? ap.selectionColor : ap.color;
        if (c == null) {
            return;
        }
        if (ap.size > 1 || ap.type == 1) {
            int oldX = (this.xCoords[0] + scale - 1) / scale;
            int oldY = (this.yCoords[0] + scale - 1) / scale;
            int i = 1;
            while (i < this.num) {
                int actX = (this.xCoords[i] + scale - 1) / scale;
                int actY = (this.yCoords[i] + scale - 1) / scale;
                DrawableLine.drawProtected(g, ap, c, c, oldX, oldY, actX, actY);
                oldX = actX;
                oldY = actY;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.num) {
                this.outX[i] = (this.xCoords[i] + scale - 1) / scale;
                this.outY[i] = (this.yCoords[i] + scale - 1) / scale;
                ++i;
            }
            g.setColor(c);
            g.drawPolyline(this.outX, this.outY, this.num);
        }
    }

    public boolean interacts(int x, int y, int scale) {
        int i = 1;
        while (i < this.num) {
            if (DrawableLine.interacts(x, y, this.xCoords[i - 1], this.yCoords[i - 1], this.xCoords[i], this.yCoords[i], Math.min(this.xCoords[i - 1], this.xCoords[i]), Math.min(this.yCoords[i - 1], this.yCoords[i]), Math.max(this.xCoords[i - 1], this.xCoords[i]), Math.max(this.yCoords[i - 1], this.yCoords[i]), scale)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void writeGML(EntryWriter out) {
        String name = "pline_";
        if (this.obj != null) {
            name = String.valueOf(name) + this.obj.getName();
        }
        out.println("<LineString name=\"l" + name + "\" srsName=\"br\">");
        out.print(" <CList>");
        int i = 0;
        while (i < this.num - 1) {
            out.print(String.valueOf(this.xCoords[i]) + "," + this.yCoords[i] + " ");
            ++i;
        }
        out.println(String.valueOf(this.xCoords[this.num - 1]) + "," + this.yCoords[this.num - 1] + "</CList>");
        out.println("</LineString>");
    }
}

