/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawableObjectType;
import drawables.DrawableObjects;
import drawables.DrawableText;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import util.EntryWriter;

public class DrawableObject {
    private Drawable[] prim = null;
    private int primNum = 0;
    private long id = 0L;
    private DrawableObjectType type = null;
    private String name = null;
    private String info = null;
    protected static final int NODEFSCALE = -1;
    private int defaultScale = -1;
    private DrawableObjects container = null;
    private boolean selected = false;

    public DrawableObject(long id, DrawableObjectType type, String name, String info, DrawableObjects container) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.info = info;
        this.container = container;
    }

    private static void adaptText(Drawable d, String name) {
        if (d != null && name != null && name.length() > 0 && d.getClass().getName().endsWith("Text") && ((DrawableText)d).getString().equals("=")) {
            ((DrawableText)d).setText(name);
        }
    }

    public void addDrawable(Drawable addPrim) {
        if (this.prim == null) {
            this.prim = new Drawable[3];
        } else if (this.primNum + 1 >= this.prim.length) {
            Drawable[] newPrim = new Drawable[this.prim.length * 2];
            int i = 0;
            while (i < this.primNum) {
                newPrim[i] = this.prim[i];
                ++i;
            }
            this.prim = newPrim;
        }
        this.prim[this.primNum++] = addPrim;
        addPrim.setObject(this);
        DrawableObject.adaptText(addPrim, this.name);
    }

    public void draw(Graphics g) {
        int i = 0;
        while (i < this.primNum) {
            this.prim[i].draw(g);
            ++i;
        }
    }

    public void draw(Graphics g, int scale) {
        int i = 0;
        while (i < this.primNum) {
            this.prim[i].draw(g, scale);
            ++i;
        }
    }

    public void draw(Graphics g, Rectangle r) {
        int i = 0;
        while (i < this.primNum) {
            this.prim[i].draw(g, r);
            ++i;
        }
    }

    public void draw(Graphics g, Rectangle r, int scale) {
        int i = 0;
        while (i < this.primNum) {
            this.prim[i].draw(g, r, scale);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.id == ((DrawableObject)obj).id;
    }

    public int getDataValue(int index) throws NumberFormatException {
        if (this.info.length() > 0 && this.container != null) {
            return this.type.getAttributeAsInteger(this.container.getMode() + this.container.getNumberOfModes() * (index + 1), this.info);
        }
        throw new NumberFormatException();
    }

    public int getDefaultScale() {
        if (this.defaultScale != -1 || this.primNum == 0) {
            return this.defaultScale;
        }
        return this.prim[0].getMinScale();
    }

    public Drawable getDrawable(int index) {
        if (index >= 0 && index < this.primNum) {
            return this.prim[index];
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public String getInfo() {
        return DrawableText.toOutputString(this.info);
    }

    public Rectangle getMBR() {
        if (this.primNum == 0) {
            return null;
        }
        Rectangle mbr = new Rectangle(this.prim[0].getMBR());
        int i = 1;
        while (i < this.primNum) {
            mbr.add(this.prim[i].getMBR());
            ++i;
        }
        return mbr;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        if (this.name.equals("=")) {
            if (this.primNum > 1 && this.prim[1] != null && this.prim[1].getClass().getName().endsWith("Text")) {
                return ((DrawableText)this.prim[1]).getString();
            }
            if (this.primNum > 0 && this.prim[0].getClass().getName().endsWith("Text")) {
                return ((DrawableText)this.prim[0]).getString();
            }
            return this.name;
        }
        return DrawableText.toOutputString(this.name);
    }

    public int getNumberOfDrawables() {
        return this.primNum;
    }

    public DrawableObjectType getObjectType() {
        return this.type;
    }

    public int getPresValue() {
        if (this.info != null && this.info.length() > 0 && this.container != null) {
            try {
                return this.type.getAttributeAsInteger(this.container.getMode(), this.info);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean isSelected() {
        return this.isSelected();
    }

    public boolean isVisible(int scale) {
        int i = 0;
        while (i < this.primNum) {
            if (this.prim[i].isVisible(scale)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDefaultScale(int scale) {
        this.defaultScale = scale;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
        int i = 0;
        while (i < this.primNum) {
            DrawableObject.adaptText(this.prim[i], name);
            ++i;
        }
    }

    public void setSelection(boolean on) {
        this.selected = on;
        int i = 0;
        while (i < this.primNum) {
            this.prim[i].setSelection(on);
            ++i;
        }
    }

    public void write(DataOutputStream out) {
        if (this.id != 0L || this.info.length() > 0) {
            try {
                out.writeByte(79);
                out.writeLong(this.id);
                out.writeUTF(this.type.getName());
                out.writeUTF(this.name);
                out.writeUTF(this.info);
                out.writeShort((short)this.defaultScale);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(EntryWriter out) {
        if (this.id != 0L || this.info.length() > 0) {
            out.print("O\t");
            out.print(this.id);
            String typeName = this.type.getName();
            out.print(String.valueOf('\t') + typeName + '\t' + this.name + '\t' + this.info);
            if (this.defaultScale != -1) {
                out.print("\t" + this.defaultScale);
            }
            out.println();
        }
    }
}

