/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.DrawableObject;
import drawables.DrawableObjects;
import drawables.DrawablePolyline;
import drawables.DrawablePresentation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public abstract class Drawable
implements Serializable,
EntryReadable {
    public static final byte AREALAYER = 0;
    public static final byte LINELAYER = 1;
    public static final byte POINTLAYER = 2;
    public static final byte TEXTLAYER = 3;
    public static final byte BITMAPLAYER = 4;
    public static final int DEFMINSCALE = Integer.MAX_VALUE;
    public static final int DEFMAXSCALE = 0;
    protected Rectangle mbr = null;
    protected int minScale = Integer.MAX_VALUE;
    protected int maxScale = 0;
    protected byte layer = 1;
    protected boolean selected = false;
    protected DrawablePresentation pres = null;
    protected DrawableObject obj = null;
    protected DrawableObjects container = null;
    protected Drawable nextOfLayer = null;

    public static double computeDistance(int x1, int y1, int x2, int y2) {
        long xDist = Math.abs(x1 - x2);
        long yDist = Math.abs(y1 - y2);
        return Math.sqrt(xDist * xDist + yDist * yDist);
    }

    public double computeDistanceTo(int x, int y) {
        Rectangle mbr = this.getMBR();
        return Drawable.computeDistance(mbr.x + mbr.width / 2, mbr.y + mbr.height / 2, x, y);
    }

    public boolean contains(Rectangle rect) {
        if (rect == null) {
            return false;
        }
        return this.getMBR().contains(rect);
    }

    public void draw(Graphics g) {
        this.draw(g, null, 1);
    }

    public void draw(Graphics g, int scale) {
        this.draw(g, null, scale);
    }

    public void draw(Graphics g, Rectangle r) {
        this.draw(g, r, 1);
    }

    public void draw(Graphics g, Rectangle r, int scale) {
        int value;
        int actMode;
        DrawablePresentation p;
        if (scale == 0) {
            scale = 1;
        }
        if (scale <= this.minScale && scale >= this.maxScale && (r == null || this.intersects(r)) && (p = this.pres.get(scale, actMode = this.container == null ? 0 : this.container.getMode(), value = this.obj == null ? Integer.MIN_VALUE : this.obj.getPresValue())) != null && p.visible) {
            this.drawProtected(g, scale, actMode, value);
        }
    }

    protected abstract void drawProtected(Graphics var1, int var2, int var3, int var4);

    public DrawableObjects getContainer() {
        return this.container;
    }

    public long getId() {
        if (this.obj == null) {
            return 0L;
        }
        return this.obj.getId();
    }

    public int getLayer() {
        return this.layer;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public Rectangle getMBR() {
        return this.mbr;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public Drawable getNextOfLayer() {
        return this.nextOfLayer;
    }

    public DrawableObject getObject() {
        return this.obj;
    }

    public DrawablePresentation getPresentation() {
        return this.pres;
    }

    public DrawablePresentation getPresentation(int scale, int mode, int value) {
        return this.pres.get(scale, mode, value);
    }

    public Object getType() {
        return this.getClass();
    }

    public boolean interacts(int x, int y, int scale) {
        return this.getMBR().contains(x, y);
    }

    public boolean intersects(Drawable prim) {
        if (prim == null) {
            return false;
        }
        return this.intersects(prim.getMBR());
    }

    public boolean intersects(Rectangle r) {
        return this.getMBR().intersects(r);
    }

    public boolean intersects(Object prim) {
        if (prim == null || !this.getClass().isInstance(prim)) {
            return false;
        }
        return this.intersects((Drawable)prim);
    }

    public boolean isContainedBy(Rectangle rect) {
        if (rect == null) {
            return false;
        }
        return rect.contains(this.getMBR());
    }

    public boolean isVisible(int scale) {
        int value;
        if (scale < 0) {
            return true;
        }
        if (scale > this.minScale || scale < this.maxScale) {
            return false;
        }
        int actMode = this.container == null ? 0 : this.container.getMode();
        DrawablePresentation p = this.pres.get(scale, actMode, value = this.obj == null ? Integer.MIN_VALUE : this.obj.getPresValue());
        return p != null && p.visible;
    }

    protected static int readCoord(DataInputStream in) throws IOException {
        byte code = in.readByte();
        if (code == -127) {
            return in.readShort();
        }
        if (code == -128) {
            return in.readInt();
        }
        return code;
    }

    protected static int readCoord(EntryInput in) {
        int coord = in.readChar();
        if (coord < 128) {
            return coord;
        }
        if ((coord -= 256) > -127) {
            return coord;
        }
        if (coord == -127) {
            return in.readWord2();
        }
        return in.readWord4();
    }

    public static Drawable readDrawable(DataInputStream r, char primType) throws IOException {
        if (primType == 'L') {
            return (DrawablePolyline)new DrawablePolyline().read(r);
        }
        throw new IOException("unknown drawable");
    }

    public static Drawable readDrawable(EntryInput r, String primType) {
        try {
            if (primType.compareTo("S") == 0) {
                primType = "Symbol";
            } else if (primType.compareTo("T") == 0) {
                primType = "Text";
            } else if (primType.compareTo("P") == 0) {
                primType = "Polygon";
            } else if (primType.compareTo("L") == 0) {
                primType = "Polyline";
            }
            Drawable prim = (Drawable)Class.forName("drawables.Drawable" + primType).newInstance();
            return (Drawable)prim.read(r);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setContainer(DrawableObjects container) {
        this.container = container;
    }

    public void setLayer(int layer) {
        this.layer = (byte)layer;
    }

    public void setMaxScale(int scale) {
        this.maxScale = scale;
    }

    public void setMBR(Rectangle newMBR) {
        if (newMBR != null) {
            this.mbr = newMBR;
        }
    }

    public void setMinScale(int scale) {
        this.minScale = scale;
    }

    public void setNextOfLayer(Drawable next) {
        this.nextOfLayer = next;
    }

    public void setObject(DrawableObject obj) {
        this.obj = obj;
    }

    public void setPresentation(DrawablePresentation pres) {
        this.pres = pres;
    }

    public void setSelection(boolean on) {
        this.selected = on;
    }

    public String toString() {
        return "layer: " + this.layer + " minScale: " + this.minScale + " maxScale: " + this.maxScale + " mbr: " + this.getMBR();
    }

    public void write(EntryWriter out, int type) {
        long id;
        this.writeProtected(out, type);
        if (this.obj != null && (id = this.obj.getId()) != 0L) {
            out.print('\t');
            out.print(Math.abs(id));
        }
        out.println();
    }

    protected static void writeCoord(DataOutputStream out, int coord) {
        try {
            if (coord > -127 && coord < 128) {
                out.writeByte(coord & 0xFF);
            } else if (coord > Short.MIN_VALUE && coord < Short.MAX_VALUE) {
                out.writeByte(-127);
                out.writeShort((short)coord);
            } else {
                out.writeByte(-128);
                out.writeInt(coord);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void writeCoord(EntryWriter out, int coord) {
        if (coord > -127 && coord < 128) {
            out.writeByte(coord & 0xFF);
        } else if (coord > Short.MIN_VALUE && coord < Short.MAX_VALUE) {
            out.writeByte(129);
            out.writeWord2(coord);
        } else {
            out.writeByte(128);
            out.writeWord4(coord);
        }
    }

    public void writeGML(EntryWriter out) {
        String name = "box_";
        if (this.obj != null) {
            name = String.valueOf(name) + this.obj.getName();
        }
        out.println("<Polygon name=\"p" + name + "\" srsName=\"br\">");
        out.println(" <LineString name=\"l" + name + "\" srsName=\"br\">");
        out.print("  <CList>");
        Rectangle mbr = this.getMBR();
        out.print(String.valueOf(mbr.x) + "," + mbr.y + " ");
        out.print(String.valueOf(mbr.x + mbr.width - 1) + "," + mbr.y + " ");
        out.print(String.valueOf(mbr.x + mbr.width - 1) + "," + (mbr.y + mbr.height - 1) + " ");
        out.print(String.valueOf(mbr.x) + "," + (mbr.y + mbr.height - 1) + " ");
        out.println(String.valueOf(mbr.x) + "," + mbr.y + "</CList>");
        out.println(" </LineString>");
        out.println("</Polygon>");
    }

    protected abstract void writeProtected(EntryWriter var1, int var2);

    public abstract EntryReadable read(EntryInput var1);
}

