/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

public class CommonBits {
    private boolean isFirst = true;
    private int commonMantissaBitsCount = 53;
    private long commonBits = 0L;
    private long commonSignExp;

    public static long signExpBits(long l) {
        return l >> 52;
    }

    public static int numCommonMostSigMantissaBits(long l, long l2) {
        int n = 0;
        int n2 = 52;
        while (n2 >= 0) {
            if (CommonBits.getBit(l, n2) != CommonBits.getBit(l2, n2)) {
                return n;
            }
            ++n;
            --n2;
        }
        return 52;
    }

    public static long zeroLowerBits(long l, int n) {
        long l2 = (1L << n) - 1L;
        long l3 = l2 ^ 0xFFFFFFFFFFFFFFFFL;
        long l4 = l & l3;
        return l4;
    }

    public static int getBit(long l, int n) {
        long l2 = 1L << n;
        return (l & l2) != 0L ? 1 : 0;
    }

    public void add(double d) {
        long l = Double.doubleToLongBits(d);
        if (this.isFirst) {
            this.commonBits = l;
            this.commonSignExp = CommonBits.signExpBits(this.commonBits);
            this.isFirst = false;
            return;
        }
        long l2 = CommonBits.signExpBits(l);
        if (l2 != this.commonSignExp) {
            this.commonBits = 0L;
            return;
        }
        this.commonMantissaBitsCount = CommonBits.numCommonMostSigMantissaBits(this.commonBits, l);
        this.commonBits = CommonBits.zeroLowerBits(this.commonBits, 64 - (12 + this.commonMantissaBitsCount));
    }

    public double getCommon() {
        return Double.longBitsToDouble(this.commonBits);
    }

    public String toString(long l) {
        double d = Double.longBitsToDouble(l);
        String string = Long.toBinaryString(l);
        String string2 = "0000000000000000000000000000000000000000000000000000000000000000" + string;
        String string3 = string2.substring(string2.length() - 64);
        String string4 = string3.substring(0, 1) + "  " + string3.substring(1, 12) + "(exp) " + string3.substring(12) + " [ " + d + " ]";
        return string4;
    }
}

