/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry geometry) {
        if (geometry.isEmpty()) {
            return false;
        }
        if (geometry instanceof Point) {
            return false;
        }
        if (geometry instanceof MultiPoint) {
            return false;
        }
        if (geometry instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)geometry).getCoordinates());
        }
        if (geometry instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)geometry);
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coordinateArray) {
        int n = 1;
        while (n < coordinateArray.length) {
            if (coordinateArray[n - 1].equals(coordinateArray[n])) {
                this.repeatedCoord = coordinateArray[n];
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon polygon) {
        if (this.hasRepeatedPoint(polygon.getExteriorRing().getCoordinates())) {
            return true;
        }
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            if (this.hasRepeatedPoint(polygon.getInteriorRingN(n).getCoordinates())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            Geometry geometry = geometryCollection.getGeometryN(n);
            if (this.hasRepeatedPoint(geometry)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

