/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class QuadtreeNestedRingTester {
    private final CGAlgorithms cga = new RobustCGAlgorithms();
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private Quadtree quadtree;
    private Coordinate nestedPt;

    public QuadtreeNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
        this.totalEnv.expandToInclude(linearRing.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildQuadtree();
        int n = 0;
        while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            List list = this.quadtree.query(linearRing.getEnvelopeInternal());
            int n2 = 0;
            while (n2 < list.size()) {
                LinearRing linearRing2 = (LinearRing)list.get(n2);
                Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
                if (linearRing != linearRing2 && linearRing.getEnvelopeInternal().intersects(linearRing2.getEnvelopeInternal())) {
                    Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, this.graph);
                    Assert.isTrue(coordinate != null, "Unable to find a ring point not a node of the search ring");
                    boolean bl = this.cga.isPointInRing(coordinate, coordinateArray2);
                    if (bl) {
                        this.nestedPt = coordinate;
                        return false;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    private void buildQuadtree() {
        this.quadtree = new Quadtree();
        int n = 0;
        while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Envelope envelope = linearRing.getEnvelopeInternal();
            this.quadtree.insert(envelope, linearRing);
            ++n;
        }
    }
}

