/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MCPointInRing;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeIntersection;
import com.vividsolutions.jts.graph.EdgeIntersectionList;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.ConnectedInteriorTester;
import com.vividsolutions.jts.operation.valid.ConsistentAreaTester;
import com.vividsolutions.jts.operation.valid.QuadtreeNestedRingTester;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.TreeSet;

public class IsValidOp {
    private final CGAlgorithms cga = new RobustCGAlgorithms();
    private Geometry parentGeometry;
    private boolean isChecked = false;
    private TopologyValidationError validErr;

    public static Coordinate findPtNotNode(Coordinate[] coordinateArray, LinearRing linearRing, GeometryGraph geometryGraph) {
        Edge edge = geometryGraph.findEdge(linearRing);
        EdgeIntersectionList edgeIntersectionList = edge.getEdgeIntersectionList();
        int n = 0;
        while (n < coordinateArray.length) {
            Coordinate coordinate = coordinateArray[n];
            if (!edgeIntersectionList.isIntersection(coordinate)) {
                return coordinate;
            }
            ++n;
        }
        return null;
    }

    public IsValidOp(Geometry geometry) {
        this.parentGeometry = geometry;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry);
        return this.validErr;
    }

    private void checkValid(Geometry geometry) {
        if (this.isChecked) {
            return;
        }
        this.validErr = null;
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof Point) {
            return;
        }
        if (geometry instanceof MultiPoint) {
            return;
        }
        if (geometry instanceof LineString) {
            this.checkValid((LineString)geometry);
        } else if (geometry instanceof Polygon) {
            this.checkValid((Polygon)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)geometry);
        } else {
            throw new UnsupportedOperationException(geometry.getClass().getName());
        }
    }

    private void checkValid(LineString lineString) {
        GeometryGraph geometryGraph = new GeometryGraph(0, lineString);
        this.checkTooFewPoints(geometryGraph);
    }

    private void checkValid(Polygon polygon) {
        GeometryGraph geometryGraph = new GeometryGraph(0, polygon);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkNoSelfIntersectingRings(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesInShell(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(geometryGraph);
    }

    private void checkValid(MultiPolygon multiPolygon) {
        GeometryGraph geometryGraph = new GeometryGraph(0, multiPolygon);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkNoSelfIntersectingRings(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        int n = 0;
        while (n < multiPolygon.getNumGeometries()) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
            this.checkHolesInShell(polygon, geometryGraph);
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < multiPolygon.getNumGeometries()) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n2);
            this.checkHolesNotNested(polygon, geometryGraph);
            if (this.validErr != null) {
                return;
            }
            ++n2;
        }
        this.checkShellsNotNested(multiPolygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(geometryGraph);
    }

    private void checkValid(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            Geometry geometry = geometryCollection.getGeometryN(n);
            this.checkValid(geometry);
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
    }

    private void checkTooFewPoints(GeometryGraph geometryGraph) {
        if (geometryGraph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(TopologyValidationError.TOO_FEW_POINTS, geometryGraph.getInvalidPoint());
            return;
        }
    }

    private void checkConsistentArea(GeometryGraph geometryGraph) {
        ConsistentAreaTester consistentAreaTester = new ConsistentAreaTester(geometryGraph);
        boolean bl = consistentAreaTester.isNodeConsistentArea();
        if (!bl) {
            this.validErr = new TopologyValidationError(TopologyValidationError.SELF_INTERSECTION, consistentAreaTester.getInvalidPoint());
            return;
        }
        if (consistentAreaTester.hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(TopologyValidationError.DUPLICATE_RINGS, consistentAreaTester.getInvalidPoint());
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph geometryGraph) {
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.checkSelfIntersectingRing(edge.getEdgeIntersectionList());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkSelfIntersectingRing(EdgeIntersectionList edgeIntersectionList) {
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        boolean bl = true;
        Iterator iterator = edgeIntersectionList.iterator();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
            if (bl) {
                bl = false;
                continue;
            }
            if (treeSet.contains(edgeIntersection.coord)) {
                this.validErr = new TopologyValidationError(TopologyValidationError.RING_SELF_INTERSECTION, edgeIntersection.coord);
                return;
            }
            treeSet.add(edgeIntersection.coord);
        }
    }

    private void checkHolesInShell(Polygon polygon, GeometryGraph geometryGraph) {
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        MCPointInRing mCPointInRing = new MCPointInRing(linearRing);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            boolean bl;
            LinearRing linearRing2 = (LinearRing)polygon.getInteriorRingN(n);
            Coordinate coordinate = IsValidOp.findPtNotNode(linearRing2.getCoordinates(), linearRing, geometryGraph);
            Assert.isTrue(coordinate != null, "Unable to find a hole point not a vertex of the shell");
            boolean bl2 = bl = !mCPointInRing.isInside(coordinate);
            if (bl) {
                this.validErr = new TopologyValidationError(TopologyValidationError.HOLE_OUTSIDE_SHELL, coordinate);
                return;
            }
            ++n;
        }
    }

    private void checkHolesNotNested(Polygon polygon, GeometryGraph geometryGraph) {
        QuadtreeNestedRingTester quadtreeNestedRingTester = new QuadtreeNestedRingTester(geometryGraph);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            LinearRing linearRing = (LinearRing)polygon.getInteriorRingN(n);
            quadtreeNestedRingTester.add(linearRing);
            ++n;
        }
        boolean bl = quadtreeNestedRingTester.isNonNested();
        if (!bl) {
            this.validErr = new TopologyValidationError(TopologyValidationError.NESTED_HOLES, quadtreeNestedRingTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon multiPolygon, GeometryGraph geometryGraph) {
        int n = 0;
        while (n < multiPolygon.getNumGeometries()) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
            LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
            int n2 = 0;
            while (n2 < multiPolygon.getNumGeometries()) {
                if (n != n2) {
                    Polygon polygon2 = (Polygon)multiPolygon.getGeometryN(n2);
                    this.checkShellNotNested(linearRing, polygon2, geometryGraph);
                    if (this.validErr != null) {
                        return;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void checkShellNotNested(LinearRing linearRing, Polygon polygon, GeometryGraph geometryGraph) {
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        LinearRing linearRing2 = (LinearRing)polygon.getExteriorRing();
        Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
        Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, geometryGraph);
        if (coordinate == null) {
            return;
        }
        boolean bl = this.cga.isPointInRing(coordinate, coordinateArray2);
        if (!bl) {
            return;
        }
        if (polygon.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(TopologyValidationError.NESTED_SHELLS, coordinate);
            return;
        }
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            LinearRing linearRing3 = (LinearRing)polygon.getInteriorRingN(n);
            this.checkShellInsideHole(linearRing, linearRing3, geometryGraph);
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
    }

    private void checkShellInsideHole(LinearRing linearRing, LinearRing linearRing2, GeometryGraph geometryGraph) {
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
        Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, geometryGraph);
        if (coordinate != null) {
            boolean bl = this.cga.isPointInRing(coordinate, coordinateArray2);
            if (!bl) {
                this.validErr = new TopologyValidationError(TopologyValidationError.NESTED_SHELLS, coordinate);
            }
            return;
        }
        Coordinate coordinate2 = IsValidOp.findPtNotNode(coordinateArray2, linearRing, geometryGraph);
        if (coordinate2 != null) {
            boolean bl = this.cga.isPointInRing(coordinate2, coordinateArray);
            if (bl) {
                this.validErr = new TopologyValidationError(TopologyValidationError.NESTED_SHELLS, coordinate2);
            }
            return;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
    }

    private void checkConnectedInteriors(GeometryGraph geometryGraph) {
        ConnectedInteriorTester connectedInteriorTester = new ConnectedInteriorTester(geometryGraph);
        if (!connectedInteriorTester.isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(TopologyValidationError.DISCONNECTED_INTERIOR, connectedInteriorTester.getCoordinate());
        }
    }
}

