/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.graph.Label;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeEndBundle
extends EdgeEnd {
    private List edgeEnds = new ArrayList();

    public EdgeEndBundle(EdgeEnd edgeEnd) {
        super(edgeEnd.getEdge(), edgeEnd.getCoordinate(), edgeEnd.getDirectedCoordinate(), new Label(edgeEnd.getLabel()));
        this.insert(edgeEnd);
    }

    public Label getLabel() {
        return this.label;
    }

    public Iterator iterator() {
        return this.edgeEnds.iterator();
    }

    public List getEdgeEnds() {
        return this.edgeEnds;
    }

    public void insert(EdgeEnd edgeEnd) {
        this.edgeEnds.add(edgeEnd);
    }

    public void computeLabel() {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            if (!edgeEnd.getLabel().isArea()) continue;
            bl = true;
        }
        this.label = bl ? new Label(-1, -1, -1) : new Label(-1);
        int n = 0;
        while (n < 2) {
            this.computeLabelOn(n);
            if (bl) {
                this.computeLabelSides(n);
            }
            ++n;
        }
    }

    private void computeLabelOn(int n) {
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            int n3 = edgeEnd.getLabel().getLocation(n);
            if (n3 == 1) {
                ++n2;
            }
            if (n3 != 0) continue;
            bl = true;
        }
        int n4 = -1;
        if (bl) {
            n4 = 0;
        }
        if (n2 > 0) {
            n4 = GeometryGraph.determineBoundary(n2);
        }
        this.label.setLocation(n, n4);
    }

    private void computeLabelSides(int n) {
        this.computeLabelSide(n, 1);
        this.computeLabelSide(n, 2);
    }

    private void computeLabelSide(int n, int n2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            if (!edgeEnd.getLabel().isArea()) continue;
            int n3 = edgeEnd.getLabel().getLocation(n, n2);
            if (n3 == 0) {
                this.label.setLocation(n, n2, 0);
                return;
            }
            if (n3 != 2) continue;
            this.label.setLocation(n, n2, 2);
        }
    }

    void updateIM(IntersectionMatrix intersectionMatrix) {
        Edge.updateIM(this.label, intersectionMatrix);
    }

    public void print(PrintStream printStream) {
        printStream.println("EdgeEndBundle--> Label: " + this.label);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            edgeEnd.print(printStream);
            printStream.println();
        }
    }
}

