/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.EdgeIntersection;
import com.vividsolutions.jts.graph.EdgeIntersectionList;
import com.vividsolutions.jts.graph.Label;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeEndBuilder {
    public List computeEdgeEnds(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            this.computeEdgeEnds(edge, arrayList);
        }
        return arrayList;
    }

    public void computeEdgeEnds(Edge edge, List list) {
        EdgeIntersectionList edgeIntersectionList = edge.getEdgeIntersectionList();
        edgeIntersectionList.addEndpoints();
        Iterator iterator = edgeIntersectionList.iterator();
        EdgeIntersection edgeIntersection = null;
        EdgeIntersection edgeIntersection2 = null;
        if (!iterator.hasNext()) {
            return;
        }
        EdgeIntersection edgeIntersection3 = (EdgeIntersection)iterator.next();
        do {
            edgeIntersection = edgeIntersection2;
            edgeIntersection2 = edgeIntersection3;
            edgeIntersection3 = null;
            if (iterator.hasNext()) {
                edgeIntersection3 = (EdgeIntersection)iterator.next();
            }
            if (edgeIntersection2 == null) continue;
            this.createEdgeEndForPrev(edge, list, edgeIntersection2, edgeIntersection);
            this.createEdgeEndForNext(edge, list, edgeIntersection2, edgeIntersection3);
        } while (edgeIntersection2 != null);
    }

    void createEdgeEndForPrev(Edge edge, List list, EdgeIntersection edgeIntersection, EdgeIntersection edgeIntersection2) {
        int n = edgeIntersection.segmentIndex;
        if (edgeIntersection.dist == 0.0) {
            if (n == 0) {
                return;
            }
            --n;
        }
        Coordinate coordinate = edge.getCoordinate(n);
        if (edgeIntersection2 != null && edgeIntersection2.segmentIndex >= n) {
            coordinate = edgeIntersection2.coord;
        }
        Label label = new Label(edge.getLabel());
        label.flip();
        EdgeEnd edgeEnd = new EdgeEnd(edge, edgeIntersection.coord, coordinate, label);
        list.add(edgeEnd);
    }

    void createEdgeEndForNext(Edge edge, List list, EdgeIntersection edgeIntersection, EdgeIntersection edgeIntersection2) {
        int n = edgeIntersection.segmentIndex + 1;
        if (n >= edge.getNumPoints() && edgeIntersection2 == null) {
            return;
        }
        Coordinate coordinate = edge.getCoordinate(n);
        if (edgeIntersection2 != null && edgeIntersection2.segmentIndex == edgeIntersection.segmentIndex) {
            coordinate = edgeIntersection2.coord;
        }
        EdgeEnd edgeEnd = new EdgeEnd(edge, edgeIntersection.coord, coordinate, new Label(edge.getLabel()));
        list.add(edgeEnd);
    }
}

