/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PointBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;

    public PointBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory, PointLocator pointLocator) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
        this.ptLocator = pointLocator;
    }

    public List build(int n) {
        List list = this.collectNodes(n);
        List list2 = this.simplifyPoints(list);
        return list2;
    }

    private List collectNodes(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator = this.op.getGraph().getNodes().iterator();
        while (iterator.hasNext()) {
            Label label;
            Node node = (Node)iterator.next();
            if (node.isInResult() || !OverlayOp.isResultOfOp(label = node.getLabel(), n)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private List simplifyPoints(List list) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Coordinate coordinate = node.getCoordinate();
            if (this.op.isCoveredByLA(coordinate)) continue;
            Point point = this.geometryFactory.createPoint(coordinate);
            arrayList.add(point);
        }
        return arrayList;
    }
}

