/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.graph.Depth;
import com.vividsolutions.jts.graph.DirectedEdge;
import com.vividsolutions.jts.graph.DirectedEdgeStar;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeList;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Node;
import com.vividsolutions.jts.graph.PlanarGraph;
import com.vividsolutions.jts.operation.GeometryGraphOperation;
import com.vividsolutions.jts.operation.overlay.LineBuilder;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PointBuilder;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import com.vividsolutions.jts.util.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlayOp
extends GeometryGraphOperation {
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;
    private final PointLocator ptLocator = new PointLocator();
    private GeometryFactory geomFact;
    private Geometry resultGeom;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();
    private List resultPolyList = new ArrayList();
    private List resultLineList = new ArrayList();
    private List resultPointList = new ArrayList();

    public static Geometry overlayOp(Geometry geometry, Geometry geometry2, int n) {
        OverlayOp overlayOp = new OverlayOp(geometry, geometry2);
        Geometry geometry3 = overlayOp.getResultGeometry(n);
        return geometry3;
    }

    public static boolean isResultOfOp(Label label, int n) {
        int n2 = label.getLocation(0);
        int n3 = label.getLocation(1);
        return OverlayOp.isResultOfOp(n2, n3, n);
    }

    public static boolean isResultOfOp(int n, int n2, int n3) {
        if (n == 1) {
            n = 0;
        }
        if (n2 == 1) {
            n2 = 0;
        }
        switch (n3) {
            case 1: {
                return n == 0 && n2 == 0;
            }
            case 2: {
                return n == 0 || n2 == 0;
            }
            case 3: {
                return n == 0 && n2 != 0;
            }
            case 4: {
                return n == 0 && n2 != 0 || n != 0 && n2 == 0;
            }
        }
        return false;
    }

    public OverlayOp(Geometry geometry, Geometry geometry2) {
        super(geometry, geometry2);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.geomFact = new GeometryFactory(geometry.getPrecisionModel(), geometry.getSRID());
    }

    public Geometry getResultGeometry(int n) {
        this.computeOverlay(n);
        return this.resultGeom;
    }

    public PlanarGraph getGraph() {
        return this.graph;
    }

    private void computeOverlay(int n) {
        this.copyPoints(0);
        this.copyPoints(1);
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        this.arg[0].computeEdgeIntersections(this.arg[1], this.li, true);
        ArrayList arrayList = new ArrayList();
        this.arg[0].computeSplitEdges(arrayList);
        this.arg[1].computeSplitEdges(arrayList);
        ArrayList arrayList2 = arrayList;
        this.insertUniqueEdges(arrayList);
        this.computeLabelsFromDepths();
        this.replaceCollapsedEdges();
        this.graph.addEdges(this.edgeList);
        this.computeLabelling();
        this.labelIncompleteNodes();
        this.findResultAreaEdges(n);
        this.cancelDuplicateResultEdges();
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.geomFact, this.cga);
        polygonBuilder.add(this.graph);
        this.resultPolyList = polygonBuilder.getPolygons();
        LineBuilder lineBuilder = new LineBuilder(this, this.geomFact, this.ptLocator);
        this.resultLineList = lineBuilder.build(n);
        PointBuilder pointBuilder = new PointBuilder(this, this.geomFact, this.ptLocator);
        this.resultPointList = pointBuilder.build(n);
        this.resultGeom = this.computeGeometry(this.resultPointList, this.resultLineList, this.resultPolyList);
    }

    private void insertUniqueEdges(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.insertUniqueEdge(edge);
        }
    }

    protected void insertUniqueEdge(Edge edge) {
        int n = this.edgeList.findEdgeIndex(edge);
        if (n >= 0) {
            Depth depth;
            Edge edge2 = (Edge)this.edgeList.get(n);
            Label label = edge2.getLabel();
            Label label2 = edge.getLabel();
            if (!edge2.isPointwiseEqual(edge)) {
                label2 = new Label(edge.getLabel());
                label2.flip();
            }
            if ((depth = edge2.getDepth()).isNull()) {
                depth.add(label);
            }
            depth.add(label2);
            label.merge(label2);
        } else {
            this.edgeList.add(edge);
        }
    }

    private void computeLabelsFromDepths() {
        Iterator iterator = ((AbstractList)this.edgeList).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Label label = edge.getLabel();
            Depth depth = edge.getDepth();
            if (depth.isNull()) continue;
            depth.normalize();
            int n = 0;
            while (n < 2) {
                if (!label.isNull(n) && label.isArea() && !depth.isNull(n)) {
                    if (depth.getDelta(n) == 0) {
                        label.toLine(n);
                    } else {
                        Assert.isTrue(!depth.isNull(n, 1), "depth of LEFT side has not been initialized");
                        label.setLocation(n, 1, depth.getLocation(n, 1));
                        Assert.isTrue(!depth.isNull(n, 2), "depth of RIGHT side has not been initialized");
                        label.setLocation(n, 2, depth.getLocation(n, 2));
                    }
                }
                ++n;
            }
        }
    }

    private void replaceCollapsedEdges() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Iterator iterator = ((AbstractList)this.edgeList).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.isCollapsed()) continue;
            iterator.remove();
            arrayList.add(edge.getCollapsedEdge());
        }
        this.edgeList.addAll(arrayList);
    }

    private void copyPoints(int n) {
        Iterator iterator = this.arg[n].getNodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Node node2 = this.graph.addNode(node.getCoordinate());
            node2.setLabel(n, node.getLabel().getLocation(n));
        }
    }

    private void computeLabelling() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.getEdges().computeLabelling(this.arg);
        }
        this.mergeSymLabels();
        this.updateNodeLabelling();
    }

    private void mergeSymLabels() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ((DirectedEdgeStar)node.getEdges()).mergeSymLabels();
        }
    }

    private void updateNodeLabelling() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Label label = ((DirectedEdgeStar)node.getEdges()).getLabel();
            node.getLabel().merge(label);
        }
    }

    private void labelIncompleteNodes() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Label label = node.getLabel();
            if (node.isIsolated()) {
                if (label.isNull(0)) {
                    this.labelIncompleteNode(node, 0);
                } else {
                    this.labelIncompleteNode(node, 1);
                }
            }
            ((DirectedEdgeStar)node.getEdges()).updateLabelling(label);
        }
    }

    private void labelIncompleteNode(Node node, int n) {
        int n2 = this.ptLocator.locate(node.getCoordinate(), this.arg[n].getGeometry());
        node.getLabel().setLocation(n, n2);
    }

    private void findResultAreaEdges(int n) {
        Iterator iterator = this.graph.getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            Label label = directedEdge.getLabel();
            if (!label.isArea() || directedEdge.isInteriorAreaEdge() || !OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), n)) continue;
            directedEdge.setInResult(true);
        }
    }

    private void cancelDuplicateResultEdges() {
        Iterator iterator = this.graph.getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            DirectedEdge directedEdge2 = directedEdge.getSym();
            if (!directedEdge.isInResult() || !directedEdge2.isInResult()) continue;
            directedEdge.setInResult(false);
            directedEdge2.setInResult(false);
        }
    }

    public boolean isCoveredByLA(Coordinate coordinate) {
        if (this.isCovered(coordinate, this.resultLineList)) {
            return true;
        }
        return this.isCovered(coordinate, this.resultPolyList);
    }

    public boolean isCoveredByA(Coordinate coordinate) {
        return this.isCovered(coordinate, this.resultPolyList);
    }

    private boolean isCovered(Coordinate coordinate, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            int n = this.ptLocator.locate(coordinate, geometry);
            if (n == 2) continue;
            return true;
        }
        return false;
    }

    private Geometry computeGeometry(List list, List list2, List list3) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        return this.geomFact.buildGeometry(arrayList);
    }
}

