/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.ConnectedElementPointFilter;
import com.vividsolutions.jts.operation.distance.LineExtracterFilter;
import com.vividsolutions.jts.operation.distance.PointExtracterFilter;
import com.vividsolutions.jts.operation.distance.PolygonExtracterFilter;
import java.util.List;

public class DistanceOp {
    private PointLocator ptLocator = new PointLocator();
    private Geometry[] geom;
    private double minDistance = Double.MAX_VALUE;

    public static double distance(Geometry geometry, Geometry geometry2) {
        DistanceOp distanceOp = new DistanceOp(geometry, geometry2);
        return distanceOp.distance();
    }

    public DistanceOp(Geometry geometry, Geometry geometry2) {
        this.geom = new Geometry[2];
        this.geom[0] = geometry;
        this.geom[1] = geometry2;
    }

    public double distance() {
        this.computeMinDistance();
        return this.minDistance;
    }

    private void updateMinDistance(double d) {
        if (d < this.minDistance) {
            this.minDistance = d;
        }
    }

    private void computeMinDistance() {
        List list;
        List list2 = PolygonExtracterFilter.getPolygons(this.geom[0]);
        List list3 = PolygonExtracterFilter.getPolygons(this.geom[1]);
        if (list3.size() > 0) {
            list = ConnectedElementPointFilter.getCoordinates(this.geom[0]);
            this.computeInside(list, list3);
            if (this.minDistance <= 0.0) {
                return;
            }
        }
        if (list2.size() > 0) {
            list = ConnectedElementPointFilter.getCoordinates(this.geom[1]);
            this.computeInside(list, list2);
            if (this.minDistance <= 0.0) {
                return;
            }
        }
        list = LineExtracterFilter.getLines(this.geom[0]);
        List list4 = LineExtracterFilter.getLines(this.geom[1]);
        List list5 = PointExtracterFilter.getPoints(this.geom[0]);
        List list6 = PointExtracterFilter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(list, list4);
        if (this.minDistance <= 0.0) {
            return;
        }
        this.computeMinDistanceLinesPoints(list, list6);
        if (this.minDistance <= 0.0) {
            return;
        }
        this.computeMinDistanceLinesPoints(list4, list5);
        if (this.minDistance <= 0.0) {
            return;
        }
        this.computeMinDistancePoints(list5, list6);
    }

    private void computeInside(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Coordinate coordinate = (Coordinate)list.get(n);
            int n2 = 0;
            while (n2 < list2.size()) {
                Polygon polygon = (Polygon)list2.get(n2);
                this.computeInside(coordinate, polygon);
                if (this.minDistance <= 0.0) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void computeInside(Coordinate coordinate, Polygon polygon) {
        if (2 != this.ptLocator.locate(coordinate, (Geometry)polygon)) {
            this.minDistance = 0.0;
        }
    }

    private void computeMinDistanceLines(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            LineString lineString = (LineString)list.get(n);
            int n2 = 0;
            while (n2 < list2.size()) {
                LineString lineString2 = (LineString)list2.get(n2);
                this.computeMinDistance(lineString, lineString2);
                if (this.minDistance <= 0.0) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void computeMinDistancePoints(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Point point = (Point)list.get(n);
            int n2 = 0;
            while (n2 < list2.size()) {
                Point point2 = (Point)list2.get(n2);
                double d = point.getCoordinate().distance(point2.getCoordinate());
                this.updateMinDistance(d);
                if (this.minDistance <= 0.0) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void computeMinDistanceLinesPoints(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            LineString lineString = (LineString)list.get(n);
            int n2 = 0;
            while (n2 < list2.size()) {
                Point point = (Point)list2.get(n2);
                this.computeMinDistance(lineString, point);
                if (this.minDistance <= 0.0) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void computeMinDistance(LineString lineString, LineString lineString2) {
        if (lineString.getEnvelopeInternal().distance(lineString2.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = lineString2.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            int n2 = 0;
            while (n2 < coordinateArray2.length - 1) {
                double d = CGAlgorithms.distanceLineLine(coordinateArray[n], coordinateArray[n + 1], coordinateArray2[n2], coordinateArray2[n2 + 1]);
                this.updateMinDistance(d);
                if (this.minDistance <= 0.0) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void computeMinDistance(LineString lineString, Point point) {
        if (lineString.getEnvelopeInternal().distance(point.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate coordinate = point.getCoordinate();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            double d = CGAlgorithms.distancePointLine(coordinate, coordinateArray[n], coordinateArray[n + 1]);
            this.updateMinDistance(d);
            if (this.minDistance <= 0.0) {
                return;
            }
            ++n;
        }
    }
}

