/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class LoopFilter {
    private static final Coordinate[] arrayTypeCoordinate = new Coordinate[0];
    private int maxPointsInLoop = 10;
    private double maxLoopExtent = 10.0;
    private List newPts = new ArrayList();

    public Coordinate[] filter(Coordinate[] coordinateArray) {
        this.newPts.clear();
        int n = 0;
        while (n < coordinateArray.length) {
            this.addPoint(coordinateArray[n]);
            int n2 = this.checkForLoop(coordinateArray, n);
            ++n;
            if (n2 <= 0) continue;
            Assert.isTrue(coordinateArray[n - 1].equals(coordinateArray[n - 1 + n2]), "non-loop found in LoopFilter");
            n += n2;
        }
        return this.newPts.toArray(arrayTypeCoordinate);
    }

    private void addPoint(Coordinate coordinate) {
        if (this.newPts.size() >= 1 && this.newPts.get(this.newPts.size() - 1).equals(coordinate)) {
            return;
        }
        this.newPts.add(coordinate);
    }

    private int checkForLoop(Coordinate[] coordinateArray, int n) {
        Coordinate coordinate = coordinateArray[n];
        Envelope envelope = new Envelope();
        envelope.expandToInclude(coordinate);
        int n2 = n;
        int n3 = 1;
        while (n3 <= this.maxPointsInLoop) {
            n2 = n + n3;
            if (n2 >= coordinateArray.length) break;
            envelope.expandToInclude(coordinateArray[n2]);
            if (coordinateArray[n2].equals(coordinate) && envelope.getHeight() < this.maxLoopExtent && envelope.getWidth() < this.maxLoopExtent) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }
}

