/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.graph.DirectedEdge;
import com.vividsolutions.jts.graph.DirectedEdgeStar;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Node;
import com.vividsolutions.jts.operation.buffer.RightmostEdgeFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BufferSubgraph
implements Comparable {
    private RightmostEdgeFinder finder;
    private List dirEdgeList = new ArrayList();
    private List nodes = new ArrayList();
    private Coordinate rightMostCoord = null;

    public BufferSubgraph(CGAlgorithms cGAlgorithms) {
        this.finder = new RightmostEdgeFinder(cGAlgorithms);
    }

    public List getDirectedEdges() {
        return this.dirEdgeList;
    }

    public List getNodes() {
        return this.nodes;
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord;
    }

    public void create(Node node) {
        this.add(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightMostCoord = this.finder.getCoordinate();
    }

    private void add(Node node) {
        node.setVisited(true);
        this.nodes.add(node);
        Iterator iterator = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            this.dirEdgeList.add(directedEdge);
            DirectedEdge directedEdge2 = directedEdge.getSym();
            Node node2 = directedEdge2.getNode();
            if (node2.isVisited()) continue;
            this.add(node2);
        }
    }

    private void clearVisitedEdges() {
        Iterator iterator = this.dirEdgeList.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            directedEdge.setVisited(false);
        }
    }

    public void computeDepth(int n) {
        this.clearVisitedEdges();
        DirectedEdge directedEdge = this.finder.getEdge();
        Node node = directedEdge.getNode();
        Label label = directedEdge.getLabel();
        directedEdge.setEdgeDepths(2, n);
        this.computeNodeDepth(node, directedEdge);
    }

    private void computeNodeDepth(Node node, DirectedEdge directedEdge) {
        DirectedEdge directedEdge2;
        Object object;
        if (directedEdge.isVisited()) {
            return;
        }
        ((DirectedEdgeStar)node.getEdges()).computeDepths(directedEdge);
        Iterator iterator = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (iterator.hasNext()) {
            object = (DirectedEdge)iterator.next();
            ((DirectedEdge)object).setVisited(true);
            directedEdge2 = ((DirectedEdge)object).getSym();
            directedEdge2.setDepth(1, ((DirectedEdge)object).getDepth(2));
            directedEdge2.setDepth(2, ((DirectedEdge)object).getDepth(1));
        }
        object = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (object.hasNext()) {
            directedEdge2 = (DirectedEdge)object.next();
            DirectedEdge directedEdge3 = directedEdge2.getSym();
            Node node2 = directedEdge3.getNode();
            this.computeNodeDepth(node2, directedEdge3);
        }
    }

    public void findResultEdges() {
        Iterator iterator = this.dirEdgeList.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (directedEdge.getDepth(2) < 1 || directedEdge.getDepth(1) != 0 || directedEdge.isInteriorAreaEdge()) continue;
            directedEdge.setInResult(true);
        }
    }

    public int compareTo(Object object) {
        BufferSubgraph bufferSubgraph = (BufferSubgraph)object;
        if (this.rightMostCoord.x < bufferSubgraph.rightMostCoord.x) {
            return -1;
        }
        if (this.rightMostCoord.x > bufferSubgraph.rightMostCoord.x) {
            return 1;
        }
        return 0;
    }
}

