/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeList;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Node;
import com.vividsolutions.jts.graph.PlanarGraph;
import com.vividsolutions.jts.operation.GeometryGraphOperation;
import com.vividsolutions.jts.operation.buffer.BufferEdgeBuilder;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BufferOp
extends GeometryGraphOperation {
    private GeometryFactory geomFact;
    private Geometry resultGeom;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();

    public static Geometry bufferOp(Geometry geometry, double d) {
        BufferOp bufferOp = new BufferOp(geometry);
        Geometry geometry2 = bufferOp.getResultGeometry(d);
        return geometry2;
    }

    public static Geometry bufferOp(Geometry geometry, double d, int n) {
        BufferOp bufferOp = new BufferOp(geometry);
        Geometry geometry2 = bufferOp.getResultGeometry(d, n);
        return geometry2;
    }

    private static int depthDelta(Label label) {
        int n = label.getLocation(0, 1);
        int n2 = label.getLocation(0, 2);
        if (n == 0 && n2 == 2) {
            return 1;
        }
        if (n == 2 && n2 == 0) {
            return -1;
        }
        return 0;
    }

    public BufferOp(Geometry geometry) {
        super(geometry);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.geomFact = new GeometryFactory(geometry.getPrecisionModel(), geometry.getSRID());
    }

    public Geometry getResultGeometry(double d) {
        this.computeBuffer(d, 6);
        return this.resultGeom;
    }

    public Geometry getResultGeometry(double d, int n) {
        this.computeBuffer(d, n);
        return this.resultGeom;
    }

    private void computeBuffer(double d, int n) {
        Object object;
        BufferEdgeBuilder bufferEdgeBuilder = new BufferEdgeBuilder(this.cga, this.li, d, this.resultPrecisionModel, n);
        List list = bufferEdgeBuilder.getEdges(this.getArgGeometry(0));
        List list2 = this.nodeEdges(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            this.insertEdge((Edge)object);
        }
        this.replaceCollapsedEdges();
        this.graph.addEdges(this.edgeList);
        object = this.createSubgraphs();
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.geomFact, this.cga);
        this.buildSubgraphs((List)object, polygonBuilder);
        List list3 = polygonBuilder.getPolygons();
        this.resultGeom = this.computeGeometry(list3);
    }

    private List nodeEdges(List list) {
        Object object;
        GeometryGraph geometryGraph = new GeometryGraph(0, this.geomFact.getPrecisionModel(), 0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            geometryGraph.addEdge((Edge)object);
        }
        object = geometryGraph.computeSelfNodes(this.li, false);
        ArrayList arrayList = new ArrayList();
        geometryGraph.computeSplitEdges(arrayList);
        return arrayList;
    }

    protected void insertEdge(Edge edge) {
        int n = this.edgeList.findEdgeIndex(edge);
        if (n >= 0) {
            Edge edge2 = (Edge)this.edgeList.get(n);
            Label label = edge2.getLabel();
            Label label2 = edge.getLabel();
            if (!edge2.isPointwiseEqual(edge)) {
                label2 = new Label(edge.getLabel());
                label2.flip();
            }
            label.merge(label2);
            int n2 = BufferOp.depthDelta(label2);
            int n3 = edge2.getDepthDelta();
            int n4 = n3 + n2;
            edge2.setDepthDelta(n4);
            this.checkDimensionalCollapse(label2, label);
        } else {
            this.edgeList.add(edge);
            edge.setDepthDelta(BufferOp.depthDelta(edge.getLabel()));
        }
    }

    private void checkDimensionalCollapse(Label label, Label label2) {
        if (label2.isArea() && label.isArea()) {
            int n = 0;
            while (n < 2) {
                if (!label.isNull(n) && label.getLocation(n, 1) == label2.getLocation(n, 2) && label.getLocation(n, 2) == label2.getLocation(n, 1)) {
                    label2.toLine(n);
                }
                ++n;
            }
        }
    }

    private void replaceCollapsedEdges() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Iterator iterator = ((AbstractList)this.edgeList).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.isCollapsed()) continue;
            iterator.remove();
            arrayList.add(edge.getCollapsedEdge());
        }
        this.edgeList.addAll(arrayList);
    }

    private List createSubgraphs() {
        ArrayList<BufferSubgraph> arrayList = new ArrayList<BufferSubgraph>();
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isVisited()) continue;
            BufferSubgraph bufferSubgraph = new BufferSubgraph(this.cga);
            bufferSubgraph.create(node);
            arrayList.add(bufferSubgraph);
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        return arrayList;
    }

    private void buildSubgraphs(List list, PolygonBuilder polygonBuilder) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BufferSubgraph bufferSubgraph = (BufferSubgraph)iterator.next();
            Coordinate coordinate = bufferSubgraph.getRightmostCoordinate();
            int n = 0;
            if (polygonBuilder.containsPoint(coordinate)) {
                n = 1;
            }
            bufferSubgraph.computeDepth(n);
            bufferSubgraph.findResultEdges();
            polygonBuilder.add(bufferSubgraph.getDirectedEdges(), bufferSubgraph.getNodes());
        }
    }

    private Geometry computeGeometry(List list) {
        return this.geomFact.buildGeometry(list);
    }

    private Geometry toLineStrings(Iterator iterator) {
        Object object;
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            Coordinate[] coordinateArray = ((Edge)object).getCoordinates();
            LineString lineString = this.geomFact.createLineString(coordinateArray);
            arrayList.add(lineString);
        }
        object = this.geomFact.buildGeometry(arrayList);
        return object;
    }
}

