/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.buffer.LineList;
import java.util.List;

public class BufferMultiLineBuilder {
    private static final double QUADRANT_SEGMENTS = 6.0;
    private static final double minSegmentLength = 10.0;
    private static final Coordinate[] arrayTypeCoordinate = new Coordinate[0];
    private CGAlgorithms cga;
    private LineIntersector li;
    private double angleInc;
    private double distance = 0.0;
    private LineList lineList;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private LineSegment offset0 = new LineSegment();
    private LineSegment offset1 = new LineSegment();
    private int side = 0;

    private static double facetAngle(double d, double d2) {
        int n = (int)(d2 / d) + 1;
        return d2 / (double)n;
    }

    private static double angleBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x - coordinate2.x;
        double d2 = coordinate.y - coordinate2.y;
        double d3 = coordinate3.x - coordinate2.x;
        double d4 = coordinate3.y - coordinate2.y;
        double d5 = d * d3 + d2 * d4;
        double d6 = Math.sqrt(d * d + d2 * d2);
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        double d8 = d5 / d6 / d7;
        double d9 = Math.acos(d8);
        return d9;
    }

    public BufferMultiLineBuilder(CGAlgorithms cGAlgorithms, LineIntersector lineIntersector, PrecisionModel precisionModel) {
        this.cga = cGAlgorithms;
        this.li = lineIntersector;
        this.angleInc = 0.2617993877991494;
        this.lineList = new LineList(precisionModel);
    }

    public List getLineBuffer(Coordinate[] coordinateArray, double d) {
        this.init(d);
        if (coordinateArray.length <= 1) {
            this.addCircle(coordinateArray[0], d);
        } else {
            this.computeLineBuffer(coordinateArray);
        }
        return this.lineList.getLines();
    }

    public List getRingBuffer(Coordinate[] coordinateArray, int n, double d) {
        this.init(d);
        if (coordinateArray.length <= 1) {
            this.addCircle(coordinateArray[0], d);
        } else if (coordinateArray.length == 2) {
            this.computeLineBuffer(coordinateArray);
        } else {
            this.computeRingBuffer(coordinateArray, n);
        }
        return this.lineList.getLines();
    }

    private void init(double d) {
        this.distance = d;
    }

    private void computeLineBuffer(Coordinate[] coordinateArray) {
        int n = coordinateArray.length - 1;
        this.initSideSegments(coordinateArray[0], coordinateArray[1], 1);
        int n2 = 2;
        while (n2 <= n) {
            this.addNextSegment(coordinateArray[n2], true);
            ++n2;
        }
        this.addLastSegment();
        this.addLineEndCap(coordinateArray[n - 1], coordinateArray[n]);
        this.initSideSegments(coordinateArray[n], coordinateArray[n - 1], 1);
        int n3 = n - 2;
        while (n3 >= 0) {
            this.addNextSegment(coordinateArray[n3], true);
            --n3;
        }
        this.addLastSegment();
        this.addLineEndCap(coordinateArray[1], coordinateArray[0]);
        this.lineList.endEdge();
    }

    private void computeRingBuffer(Coordinate[] coordinateArray, int n) {
        int n2 = coordinateArray.length - 1;
        this.initSideSegments(coordinateArray[n2 - 1], coordinateArray[0], n);
        int n3 = 1;
        while (n3 <= n2) {
            boolean bl = n3 != 1;
            this.addNextSegment(coordinateArray[n3], bl);
            ++n3;
        }
        this.lineList.endEdge();
    }

    private void initSideSegments(Coordinate coordinate, Coordinate coordinate2, int n) {
        this.s1 = coordinate;
        this.s2 = coordinate2;
        this.side = n;
        this.seg1.setCoordinates(coordinate, coordinate2);
        this.computeOffsetSegment(this.seg1, n, this.distance, this.offset1);
    }

    private void addNextSegment(Coordinate coordinate, boolean bl) {
        boolean bl2;
        this.s0 = this.s1;
        this.s1 = this.s2;
        this.s2 = coordinate;
        this.seg0.setCoordinates(this.s0, this.s1);
        this.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        this.seg1.setCoordinates(this.s1, this.s2);
        this.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        if (this.s1.equals(this.s2)) {
            return;
        }
        int n = this.cga.computeOrientation(this.s0, this.s1, this.s2);
        boolean bl3 = bl2 = n == -1 && this.side == 1 || n == 1 && this.side == 2;
        if (n == 0) {
            this.li.computeIntersection(this.s0, this.s1, this.s1, this.s2);
            int n2 = this.li.getIntersectionNum();
            if (n2 >= 2) {
                this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            }
        } else if (bl2) {
            if (bl) {
                this.lineList.addPt(this.offset0.p1);
            }
            this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, n, this.distance);
            this.lineList.addPt(this.offset1.p0);
            this.lineList.addPt(this.offset1.p1);
        } else {
            this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
            if (this.li.hasIntersection()) {
                this.lineList.addPt(this.li.getIntersection(0));
            } else {
                this.lineList.addPt(this.offset0.p1);
                this.lineList.endEdge();
                this.lineList.addPt(this.offset1.p0);
            }
        }
    }

    private void addLastSegment() {
        this.lineList.addPt(this.offset1.p1);
    }

    private void computeOffsetSegment(LineSegment lineSegment, int n, double d, LineSegment lineSegment2) {
        int n2 = n == 1 ? 1 : -1;
        double d2 = lineSegment.p1.x - lineSegment.p0.x;
        double d3 = lineSegment.p1.y - lineSegment.p0.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = (double)n2 * d * d2 / d4;
        double d6 = (double)n2 * d * d3 / d4;
        lineSegment2.p0.x = lineSegment.p0.x - d6;
        lineSegment2.p0.y = lineSegment.p0.y + d5;
        lineSegment2.p1.x = lineSegment.p1.x - d6;
        lineSegment2.p1.y = lineSegment.p1.y + d5;
    }

    private void addLineEndCap(Coordinate coordinate, Coordinate coordinate2) {
        LineSegment lineSegment = new LineSegment(coordinate, coordinate2);
        LineSegment lineSegment2 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 1, this.distance, lineSegment2);
        LineSegment lineSegment3 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 2, this.distance, lineSegment3);
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = Math.atan2(d2, d);
        this.lineList.addPt(lineSegment2.p1);
        this.addFillet(coordinate2, d3 + 1.5707963267948966, d3 - 1.5707963267948966, -1, this.distance);
        this.lineList.addPt(lineSegment3.p1);
    }

    private void addFillet(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, int n, double d) {
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = Math.atan2(d3, d2);
        double d5 = coordinate3.x - coordinate.x;
        double d6 = coordinate3.y - coordinate.y;
        double d7 = Math.atan2(d6, d5);
        if (n == -1) {
            if (d4 <= d7) {
                d4 += Math.PI * 2;
            }
        } else if (d4 >= d7) {
            d4 -= Math.PI * 2;
        }
        this.lineList.addPt(coordinate2);
        this.addFillet(coordinate, d4, d7, n, d);
        this.lineList.addPt(coordinate3);
    }

    private void addFillet(Coordinate coordinate, double d, double d2, int n, double d3) {
        int n2 = n < 0 ? -1 : 1;
        double d4 = Math.abs(d - d2);
        int n3 = (int)(d4 / this.angleInc + 0.5);
        if (n3 < 1) {
            return;
        }
        double d5 = 0.0;
        double d6 = d4 / (double)n3;
        double d7 = d5;
        Coordinate coordinate2 = new Coordinate();
        while (d7 < d4) {
            double d8 = d + (double)n2 * d7;
            coordinate2.x = coordinate.x + d3 * Math.cos(d8);
            coordinate2.y = coordinate.y + d3 * Math.sin(d8);
            this.lineList.addPt(coordinate2);
            d7 += d6;
        }
    }

    private void addCircle(Coordinate coordinate, double d) {
        Coordinate coordinate2 = new Coordinate(coordinate.x + d, coordinate.y);
        this.lineList.addPt(coordinate2);
        this.addFillet(coordinate, 0.0, Math.PI * 2, -1, d);
    }
}

