/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Position;
import com.vividsolutions.jts.operation.buffer.BufferLineBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BufferEdgeBuilder {
    private CGAlgorithms cga;
    private double distance;
    private BufferLineBuilder lineBuilder;
    private List edgeList = new ArrayList();

    public BufferEdgeBuilder(CGAlgorithms cGAlgorithms, LineIntersector lineIntersector, double d, PrecisionModel precisionModel, int n) {
        this.cga = cGAlgorithms;
        this.distance = d;
        this.lineBuilder = new BufferLineBuilder(cGAlgorithms, lineIntersector, precisionModel, n);
    }

    public List getEdges(Geometry geometry) {
        this.add(geometry);
        return this.edgeList;
    }

    private void addEdges(List list, int n, int n2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Coordinate[] coordinateArray = (Coordinate[])iterator.next();
            this.addEdge(coordinateArray, n, n2);
        }
    }

    private void addEdge(Coordinate[] coordinateArray, int n, int n2) {
        if (coordinateArray.length < 2) {
            return;
        }
        Edge edge = new Edge(coordinateArray, new Label(0, 1, n, n2));
        this.edgeList.add(edge);
    }

    private void add(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof Polygon) {
            this.addPolygon((Polygon)geometry);
        } else if (geometry instanceof LineString) {
            this.addLineString((LineString)geometry);
        } else if (geometry instanceof Point) {
            this.addPoint((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            this.addCollection((MultiPoint)geometry);
        } else if (geometry instanceof MultiLineString) {
            this.addCollection((MultiLineString)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)geometry);
        } else {
            throw new UnsupportedOperationException(geometry.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            Geometry geometry = geometryCollection.getGeometryN(n);
            this.add(geometry);
            ++n;
        }
    }

    private void addPoint(Point point) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coordinateArray = point.getCoordinates();
        List list = this.lineBuilder.getLineBuffer(coordinateArray, this.distance);
        this.addEdges(list, 2, 0);
    }

    private void addLineString(LineString lineString) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        List list = this.lineBuilder.getLineBuffer(coordinateArray, this.distance);
        this.addEdges(list, 2, 0);
    }

    private void addPolygon(Polygon polygon) {
        double d = this.distance;
        int n = 1;
        if (this.distance < 0.0) {
            d = -this.distance;
            n = 2;
        }
        int n2 = n == 1 ? 2 : 1;
        this.addPolygonRing((LinearRing)polygon.getExteriorRing(), d, n, 2, 0);
        int n3 = 0;
        while (n3 < polygon.getNumInteriorRing()) {
            this.addPolygonRing((LinearRing)polygon.getInteriorRingN(n3), d, Position.opposite(n), 0, 2);
            ++n3;
        }
    }

    private void addPolygonRing(LinearRing linearRing, double d, int n, int n2, int n3) {
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(linearRing.getCoordinates());
        int n4 = n2;
        int n5 = n3;
        if (this.cga.isCCW(coordinateArray)) {
            n4 = n3;
            n5 = n2;
            n = Position.opposite(n);
        }
        List list = this.lineBuilder.getRingBuffer(coordinateArray, n, d);
        this.addEdges(list, n4, n5);
    }
}

