/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeIntersection;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.graph.index.SegmentIntersector;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class IsSimpleOp {
    public boolean isSimple(LineString lineString) {
        return this.isSimpleLinearGeometry(lineString);
    }

    public boolean isSimple(MultiLineString multiLineString) {
        return this.isSimpleLinearGeometry(multiLineString);
    }

    public boolean isSimple(MultiPoint multiPoint) {
        if (multiPoint.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        int n = 0;
        while (n < multiPoint.getNumGeometries()) {
            Point point = (Point)multiPoint.getGeometryN(n);
            Coordinate coordinate = point.getCoordinate();
            if (treeSet.contains(coordinate)) {
                return false;
            }
            treeSet.add(coordinate);
            ++n;
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geometry) {
        if (geometry.isEmpty()) {
            return true;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, geometry);
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        SegmentIntersector segmentIntersector = geometryGraph.computeSelfNodes(robustLineIntersector, true);
        if (!segmentIntersector.hasIntersection()) {
            return true;
        }
        if (segmentIntersector.hasProperIntersection()) {
            return false;
        }
        if (this.hasNonEndpointIntersection(geometryGraph)) {
            return false;
        }
        return !this.hasClosedEndpointIntersection(geometryGraph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph geometryGraph) {
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            int n = edge.getMaximumSegmentIndex();
            Iterator iterator2 = edge.getEdgeIntersectionList().iterator();
            while (iterator2.hasNext()) {
                EdgeIntersection edgeIntersection = (EdgeIntersection)iterator2.next();
                if (edgeIntersection.isEndPoint(n)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph geometryGraph) {
        Object object;
        TreeMap treeMap = new TreeMap();
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            int n = ((Edge)object).getMaximumSegmentIndex();
            boolean bl = ((Edge)object).isClosed();
            Coordinate coordinate = ((Edge)object).getCoordinate(0);
            this.addEndpoint(treeMap, coordinate, bl);
            Coordinate coordinate2 = ((Edge)object).getCoordinate(((Edge)object).getNumPoints() - 1);
            this.addEndpoint(treeMap, coordinate2, bl);
        }
        object = treeMap.values().iterator();
        while (object.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)object.next();
            if (!endpointInfo.isClosed || endpointInfo.degree == 2) continue;
            return true;
        }
        return false;
    }

    private void addEndpoint(Map map, Coordinate coordinate, boolean bl) {
        EndpointInfo endpointInfo = (EndpointInfo)map.get(coordinate);
        if (endpointInfo == null) {
            endpointInfo = new EndpointInfo(coordinate);
            map.put(coordinate, endpointInfo);
        }
        endpointInfo.addEndpoint(bl);
    }

    class EndpointInfo {
        Coordinate pt;
        boolean isClosed;
        int degree;

        EndpointInfo(Coordinate coordinate) {
            this.pt = coordinate;
            this.isClosed = false;
            this.degree = 0;
        }

        void addEndpoint(boolean bl) {
            ++this.degree;
            this.isClosed |= bl;
        }
    }
}

