/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    public void add(SweepLineInterval sweepLineInterval) {
        SweepLineEvent sweepLineEvent = new SweepLineEvent(sweepLineInterval.getMin(), null, sweepLineInterval);
        this.events.add(sweepLineEvent);
        this.events.add(new SweepLineEvent(sweepLineInterval.getMax(), sweepLineEvent, sweepLineInterval));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        int n = 0;
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isDelete()) {
                sweepLineEvent.getInsertEvent().setDeleteEventIndex(n);
            }
            ++n;
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction sweepLineOverlapAction) {
        this.nOverlaps = 0;
        this.buildIndex();
        int n = 0;
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isInsert()) {
                this.processOverlaps(n, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent.getInterval(), sweepLineOverlapAction);
            }
            ++n;
        }
    }

    private void processOverlaps(int n, int n2, SweepLineInterval sweepLineInterval, SweepLineOverlapAction sweepLineOverlapAction) {
        int n3 = n;
        while (n3 < n2) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n3);
            if (sweepLineEvent.isInsert()) {
                SweepLineInterval sweepLineInterval2 = sweepLineEvent.getInterval();
                sweepLineOverlapAction.overlap(sweepLineInterval, sweepLineInterval2);
                ++this.nOverlaps;
            }
            ++n3;
        }
    }
}

