/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class STRtree
extends AbstractSTRtree
implements SpatialIndex {
    private Comparator xComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return STRtree.this.compareDoubles(STRtree.this.centreX((Envelope)((Boundable)object).getBounds()), STRtree.this.centreX((Envelope)((Boundable)object2).getBounds()));
        }
    };
    private Comparator yComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return STRtree.this.compareDoubles(STRtree.this.centreY((Envelope)((Boundable)object).getBounds()), STRtree.this.centreY((Envelope)((Boundable)object2).getBounds()));
        }
    };
    private AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object object, Object object2) {
            return ((Envelope)object).intersects((Envelope)object2);
        }
    };

    private double centreX(Envelope envelope) {
        return this.avg(envelope.getMinX(), envelope.getMaxX());
    }

    private double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    private double centreY(Envelope envelope) {
        return this.avg(envelope.getMinY(), envelope.getMaxY());
    }

    protected Comparator getComparator() {
        return this.yComparator;
    }

    protected List createParentBoundables(List list, int n) {
        Assert.isTrue(!list.isEmpty());
        int n2 = (int)Math.ceil((double)list.size() / (double)this.getNodeCapacity());
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, this.xComparator);
        List[] listArray = this.verticalSlices(arrayList, (int)Math.ceil(Math.sqrt(n2)));
        return this.createParentBoundablesFromVerticalSlices(listArray, n);
    }

    private List createParentBoundablesFromVerticalSlices(List[] listArray, int n) {
        Assert.isTrue(listArray.length > 0);
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < listArray.length) {
            arrayList.addAll(this.createParentBoundablesFromVerticalSlice(listArray[n2], n));
            ++n2;
        }
        return arrayList;
    }

    protected List createParentBoundablesFromVerticalSlice(List list, int n) {
        return super.createParentBoundables(list, n);
    }

    protected List[] verticalSlices(List list, int n) {
        int n2 = (int)Math.ceil((double)list.size() / (double)n);
        List[] listArray = new List[n];
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (n3 < n) {
            listArray[n3] = new ArrayList();
            int n4 = 0;
            while (iterator.hasNext() && n4 < n2) {
                Boundable boundable = (Boundable)iterator.next();
                listArray[n3].add(boundable);
                ++n4;
            }
            ++n3;
        }
        return listArray;
    }

    public STRtree() {
        this(10);
    }

    public STRtree(int n) {
        super(n);
    }

    protected AbstractNode createNode(int n) {
        return new AbstractNode(n){

            protected Object computeBounds() {
                Envelope envelope = null;
                Iterator iterator = this.getChildBoundables().iterator();
                while (iterator.hasNext()) {
                    Boundable boundable = (Boundable)iterator.next();
                    if (envelope == null) {
                        envelope = new Envelope((Envelope)boundable.getBounds());
                        continue;
                    }
                    envelope.expandToInclude((Envelope)boundable.getBounds());
                }
                return envelope;
            }
        };
    }

    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return this.intersectsOp;
    }

    public void insert(Envelope envelope, Object object) {
        if (envelope.isNull()) {
            return;
        }
        super.insert(envelope, object);
    }

    public List query(Envelope envelope) {
        return super.query(envelope);
    }
}

