/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.util.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSTRtree {
    protected AbstractNode root;
    private boolean built = false;
    private ArrayList itemBoundables = new ArrayList();
    private int nodeCapacity;

    public AbstractSTRtree(int n) {
        Assert.isTrue(n > 1, "Node capacity must be greater than 1");
        this.nodeCapacity = n;
    }

    public void build() {
        Assert.isTrue(!this.built);
        this.root = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
        this.built = true;
    }

    public void checkConsistency() {
        if (!this.built) {
            this.build();
        }
        HashSet hashSet = new HashSet(this.boundablesAtLevel(-1));
        Assert.equals(new Integer(new HashSet(this.itemBoundables).size()), new Integer(hashSet.size()));
    }

    protected abstract AbstractNode createNode(int var1);

    protected List createParentBoundables(List list, int n) {
        Assert.isTrue(!list.isEmpty());
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        arrayList.add(this.createNode(n));
        ArrayList arrayList2 = new ArrayList(list);
        Collections.sort(arrayList2, this.getComparator());
        Iterator iterator = ((AbstractList)arrayList2).iterator();
        while (iterator.hasNext()) {
            Boundable boundable = (Boundable)iterator.next();
            if (this.lastNode(arrayList).getChildBoundables().size() == this.nodeCapacity) {
                arrayList.add(this.createNode(n));
            }
            this.lastNode(arrayList).addChildBoundable(boundable);
        }
        return arrayList;
    }

    protected abstract Comparator getComparator();

    protected AbstractNode lastNode(List list) {
        return (AbstractNode)list.get(list.size() - 1);
    }

    protected int compareDoubles(double d, double d2) {
        return d > d2 ? 1 : (d < d2 ? -1 : 0);
    }

    private AbstractNode createHigherLevels(List list, int n) {
        Assert.isTrue(!list.isEmpty());
        List list2 = this.createParentBoundables(list, n + 1);
        if (list2.size() == 1) {
            return (AbstractNode)list2.get(0);
        }
        return this.createHigherLevels(list2, n + 1);
    }

    protected AbstractNode getRoot() {
        return this.root;
    }

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    protected void insert(Object object, Object object2) {
        Assert.isTrue(!this.built, "Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(object, object2));
    }

    protected List query(Object object) {
        if (!this.built) {
            this.build();
        }
        ArrayList arrayList = new ArrayList();
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
            return arrayList;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            this.query(object, this.root, arrayList);
        }
        return arrayList;
    }

    protected abstract IntersectsOp getIntersectsOp();

    private void query(Object object, AbstractNode abstractNode, List list) {
        Iterator iterator = abstractNode.getChildBoundables().iterator();
        while (iterator.hasNext()) {
            Boundable boundable = (Boundable)iterator.next();
            if (!this.getIntersectsOp().intersects(boundable.getBounds(), object)) continue;
            if (boundable instanceof AbstractNode) {
                this.query(object, (AbstractNode)boundable, list);
                continue;
            }
            if (boundable instanceof ItemBoundable) {
                list.add(((ItemBoundable)boundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    protected List boundablesAtLevel(int n) {
        ArrayList arrayList = new ArrayList();
        this.boundablesAtLevel(n, this.root, arrayList);
        return arrayList;
    }

    private void boundablesAtLevel(int n, AbstractNode abstractNode, Collection collection) {
        Assert.isTrue(n > -2);
        if (abstractNode.getLevel() == n) {
            collection.add(abstractNode);
            return;
        }
        Iterator iterator = abstractNode.getChildBoundables().iterator();
        while (iterator.hasNext()) {
            Boundable boundable = (Boundable)iterator.next();
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(n, (AbstractNode)boundable, collection);
                continue;
            }
            Assert.isTrue(boundable instanceof ItemBoundable);
            if (n != -1) continue;
            collection.add(boundable);
        }
    }

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

