/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.Node;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope envelope, Coordinate coordinate) {
        int n = -1;
        if (envelope.getMinX() >= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 3;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 1;
            }
        }
        if (envelope.getMaxX() <= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 2;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 0;
            }
        }
        return n;
    }

    public List getItems() {
        return this.items;
    }

    public void add(Object object) {
        this.items.add(object);
    }

    public List addAllItems(List list) {
        list.addAll(this.items);
        int n = 0;
        while (n < 4) {
            if (this.subnode[n] != null) {
                this.subnode[n].addAllItems(list);
            }
            ++n;
        }
        return list;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public void addAllItemsFromOverlapping(Envelope envelope, List list) {
        if (!this.isSearchMatch(envelope)) {
            return;
        }
        list.addAll(this.items);
        int n = 0;
        while (n < 4) {
            if (this.subnode[n] != null) {
                this.subnode[n].addAllItemsFromOverlapping(envelope, list);
            }
            ++n;
        }
    }

    int depth() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3;
            if (this.subnode[n2] != null && (n3 = this.subnode[n2].depth()) > n) {
                n = n3;
            }
            ++n2;
        }
        return n + 1;
    }

    int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            if (this.subnode[n2] != null) {
                n += this.subnode[n2].size();
            }
            ++n2;
        }
        return n + this.items.size();
    }

    int nodeCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            if (this.subnode[n2] != null) {
                n += this.subnode[n2].size();
            }
            ++n2;
        }
        return n + 1;
    }
}

