/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Key;
import com.vividsolutions.jts.index.bintree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Node
extends NodeBase {
    private Interval interval;
    private double centre;
    private int level;

    public static Node createNode(Interval interval) {
        Key key = new Key(interval);
        Node node = new Node(key.getInterval(), key.getLevel());
        return node;
    }

    public static Node createExpanded(Node node, Interval interval) {
        Interval interval2 = new Interval(interval);
        if (node != null) {
            interval2.expandToInclude(node.interval);
        }
        Node node2 = Node.createNode(interval2);
        if (node != null) {
            node2.insert(node);
        }
        return node2;
    }

    public Node(Interval interval, int n) {
        this.interval = interval;
        this.level = n;
        this.centre = (interval.getMin() + interval.getMax()) / 2.0;
    }

    public Interval getInterval() {
        return this.interval;
    }

    protected boolean isSearchMatch(Interval interval) {
        return interval.overlaps(this.interval);
    }

    public Node getNode(Interval interval) {
        int n = NodeBase.getSubnodeIndex(interval, this.centre);
        if (n != -1) {
            Node node = this.getSubnode(n);
            return node.getNode(interval);
        }
        return this;
    }

    public NodeBase find(Interval interval) {
        int n = NodeBase.getSubnodeIndex(interval, this.centre);
        if (n == -1) {
            return this;
        }
        if (this.subnode[n] != null) {
            Node node = this.subnode[n];
            return node.find(interval);
        }
        return this;
    }

    void insert(Node node) {
        Assert.isTrue(this.interval == null || this.interval.contains(node.interval));
        int n = NodeBase.getSubnodeIndex(node.interval, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[n] = node;
        } else {
            Node node2 = this.createSubnode(n);
            node2.insert(node);
            this.subnode[n] = node2;
        }
    }

    private Node getSubnode(int n) {
        if (this.subnode[n] == null) {
            this.subnode[n] = this.createSubnode(n);
        }
        return this.subnode[n];
    }

    private Node createSubnode(int n) {
        double d = 0.0;
        double d2 = 0.0;
        switch (n) {
            case 0: {
                d = this.interval.getMin();
                d2 = this.centre;
                break;
            }
            case 1: {
                d = this.centre;
                d2 = this.interval.getMax();
            }
        }
        Interval interval = new Interval(d, d2);
        Node node = new Node(interval, this.level - 1);
        return node;
    }
}

