/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.index.EdgeSetIntersector;
import com.vividsolutions.jts.graph.index.SegmentIntersector;
import com.vividsolutions.jts.graph.index.SweepLineEvent;
import com.vividsolutions.jts.graph.index.SweepLineSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List list, SegmentIntersector segmentIntersector, boolean bl) {
        if (bl) {
            this.add(list, null);
        } else {
            this.add(list);
        }
        this.computeIntersections(segmentIntersector);
    }

    public void computeIntersections(List list, List list2, SegmentIntersector segmentIntersector) {
        this.add(list, (Object)list);
        this.add(list2, (Object)list2);
        this.computeIntersections(segmentIntersector);
    }

    private void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, (Object)edge);
        }
    }

    private void add(List list, Object object) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.add(edge, object);
        }
    }

    private void add(Edge edge, Object object) {
        Coordinate[] coordinateArray = edge.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            SweepLineSegment sweepLineSegment = new SweepLineSegment(edge, n);
            SweepLineEvent sweepLineEvent = new SweepLineEvent(object, sweepLineSegment.getMinX(), null, sweepLineSegment);
            this.events.add(sweepLineEvent);
            this.events.add(new SweepLineEvent(object, sweepLineSegment.getMaxX(), sweepLineEvent, sweepLineSegment));
            ++n;
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        int n = 0;
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isDelete()) {
                sweepLineEvent.getInsertEvent().setDeleteEventIndex(n);
            }
            ++n;
        }
    }

    private void computeIntersections(SegmentIntersector segmentIntersector) {
        this.nOverlaps = 0;
        this.prepareEvents();
        int n = 0;
        while (n < this.events.size()) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(n);
            if (sweepLineEvent.isInsert()) {
                this.processOverlaps(n, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent, segmentIntersector);
            }
            ++n;
        }
    }

    private void processOverlaps(int n, int n2, SweepLineEvent sweepLineEvent, SegmentIntersector segmentIntersector) {
        SweepLineSegment sweepLineSegment = (SweepLineSegment)sweepLineEvent.getObject();
        int n3 = n;
        while (n3 < n2) {
            SweepLineEvent sweepLineEvent2 = (SweepLineEvent)this.events.get(n3);
            if (sweepLineEvent2.isInsert()) {
                SweepLineSegment sweepLineSegment2 = (SweepLineSegment)sweepLineEvent2.getObject();
                if (sweepLineEvent.edgeSet == null || sweepLineEvent.edgeSet != sweepLineEvent2.edgeSet) {
                    sweepLineSegment.computeIntersections(sweepLineSegment2, segmentIntersector);
                    ++this.nOverlaps;
                }
            }
            ++n3;
        }
    }
}

