/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph.index;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.Node;
import java.util.Collection;
import java.util.Iterator;

public class SegmentIntersector {
    private boolean hasIntersection = false;
    private boolean hasProper = false;
    private boolean hasProperInterior = false;
    private Coordinate properIntersectionPoint = null;
    private LineIntersector li;
    private boolean includeProper;
    private boolean recordIsolated;
    private boolean isSelfIntersection;
    private int numIntersections = 0;
    public int numTests = 0;
    private Collection[] bdyNodes;

    public static boolean isAdjacentSegments(int n, int n2) {
        return Math.abs(n - n2) == 1;
    }

    public SegmentIntersector(LineIntersector lineIntersector, boolean bl, boolean bl2) {
        this.li = lineIntersector;
        this.includeProper = bl;
        this.recordIsolated = bl2;
    }

    public void setBoundaryNodes(Collection collection, Collection collection2) {
        this.bdyNodes = new Collection[2];
        this.bdyNodes[0] = collection;
        this.bdyNodes[1] = collection2;
    }

    public Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProper;
    }

    public boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    private boolean isTrivialIntersection(Edge edge, int n, Edge edge2, int n2) {
        if (edge == edge2 && this.li.getIntersectionNum() == 1) {
            if (SegmentIntersector.isAdjacentSegments(n, n2)) {
                return true;
            }
            if (edge.isClosed()) {
                int n3 = edge.getNumPoints() - 1;
                if (n == 0 && n2 == n3 || n2 == 0 && n == n3) {
                    return true;
                }
            }
        }
        return false;
    }

    public void addIntersections(Edge edge, int n, Edge edge2, int n2) {
        if (edge == edge2 && n == n2) {
            return;
        }
        ++this.numTests;
        Coordinate coordinate = edge.getCoordinates()[n];
        Coordinate coordinate2 = edge.getCoordinates()[n + 1];
        Coordinate coordinate3 = edge2.getCoordinates()[n2];
        Coordinate coordinate4 = edge2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection()) {
            if (this.recordIsolated) {
                edge.setIsolated(false);
                edge2.setIsolated(false);
            }
            ++this.numIntersections;
            if (!this.isTrivialIntersection(edge, n, edge2, n2)) {
                this.hasIntersection = true;
                if (this.includeProper || !this.li.isProper()) {
                    edge.addIntersections(this.li, n, 0);
                    edge2.addIntersections(this.li, n2, 1);
                }
                if (this.li.isProper()) {
                    this.properIntersectionPoint = (Coordinate)this.li.getIntersection(0).clone();
                    this.hasProper = true;
                    if (!this.isBoundaryPoint(this.li, this.bdyNodes)) {
                        this.hasProperInterior = true;
                    }
                }
            }
        }
    }

    private boolean isBoundaryPoint(LineIntersector lineIntersector, Collection[] collectionArray) {
        if (collectionArray == null) {
            return false;
        }
        if (this.isBoundaryPoint(lineIntersector, collectionArray[0])) {
            return true;
        }
        return this.isBoundaryPoint(lineIntersector, collectionArray[1]);
    }

    private boolean isBoundaryPoint(LineIntersector lineIntersector, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Coordinate coordinate = node.getCoordinate();
            if (!lineIntersector.isIntersection(coordinate)) continue;
            return true;
        }
        return false;
    }
}

