/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.geom.Location;

public class TopologyLocation {
    int[] location;

    public TopologyLocation(int[] nArray) {
        this.init(nArray.length);
    }

    public TopologyLocation(int n, int n2, int n3) {
        this.init(3);
        this.location[0] = n;
        this.location[1] = n2;
        this.location[2] = n3;
    }

    public TopologyLocation(int n) {
        this.init(1);
        this.location[0] = n;
    }

    public TopologyLocation(TopologyLocation topologyLocation) {
        this.init(topologyLocation.location.length);
        if (topologyLocation != null) {
            int n = 0;
            while (n < this.location.length) {
                this.location[n] = topologyLocation.location[n];
                ++n;
            }
        }
    }

    private void init(int n) {
        this.location = new int[n];
        this.setAllLocations(-1);
    }

    public int get(int n) {
        if (n < this.location.length) {
            return this.location[n];
        }
        return -1;
    }

    public boolean isNull() {
        int n = 0;
        while (n < this.location.length) {
            if (this.location[n] != -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isAnyNull() {
        int n = 0;
        while (n < this.location.length) {
            if (this.location[n] == -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isEqualOnSide(TopologyLocation topologyLocation, int n) {
        return this.location[n] == topologyLocation.location[n];
    }

    public boolean isArea() {
        return this.location.length > 1;
    }

    public boolean isLine() {
        return this.location.length == 1;
    }

    public void flip() {
        if (this.location.length <= 1) {
            return;
        }
        int n = this.location[1];
        this.location[1] = this.location[2];
        this.location[2] = n;
    }

    public void setAllLocations(int n) {
        int n2 = 0;
        while (n2 < this.location.length) {
            this.location[n2] = n;
            ++n2;
        }
    }

    public void setAllLocationsIfNull(int n) {
        int n2 = 0;
        while (n2 < this.location.length) {
            if (this.location[n2] == -1) {
                this.location[n2] = n;
            }
            ++n2;
        }
    }

    public void setLocation(int n, int n2) {
        this.location[n] = n2;
    }

    public void setLocation(int n) {
        this.setLocation(0, n);
    }

    public int[] getLocations() {
        return this.location;
    }

    public void setLocations(int n, int n2, int n3) {
        this.location[0] = n;
        this.location[1] = n2;
        this.location[2] = n3;
    }

    public void setLocations(TopologyLocation topologyLocation) {
        int n = 0;
        while (n < topologyLocation.location.length) {
            this.location[n] = topologyLocation.location[n];
            ++n;
        }
    }

    public boolean allPositionsEqual(int n) {
        int n2 = 0;
        while (n2 < this.location.length) {
            if (this.location[n2] != n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void merge(TopologyLocation topologyLocation) {
        if (topologyLocation.location.length > this.location.length) {
            int[] nArray = new int[]{this.location[0], -1, -1};
            this.location = nArray;
        }
        int n = 0;
        while (n < this.location.length) {
            if (this.location[n] == -1 && n < topologyLocation.location.length) {
                this.location[n] = topologyLocation.location[n];
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.location.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(this.location[1]));
        }
        stringBuffer.append(Location.toLocationSymbol(this.location[0]));
        if (this.location.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(this.location[2]));
        }
        return stringBuffer.toString();
    }
}

