/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.geom.Coordinate;

public class Quadrant {
    public static int quadrant(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("Cannot compute the quadrant for point ( " + d + ", " + d2 + " )");
        }
        if (d >= 0.0) {
            if (d2 >= 0.0) {
                return 0;
            }
            return 3;
        }
        if (d2 >= 0.0) {
            return 1;
        }
        return 2;
    }

    public static int quadrant(Coordinate coordinate, Coordinate coordinate2) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("Cannot compute the quadrant for two identical points " + coordinate);
        }
        return Quadrant.quadrant(d, d2);
    }

    public static boolean isOpposite(int n, int n2) {
        if (n == n2) {
            return false;
        }
        int n3 = (n - n2 + 4) % 4;
        return n3 == 2;
    }

    public static int commonHalfPlane(int n, int n2) {
        int n3;
        if (n == n2) {
            return n;
        }
        int n4 = (n - n2 + 4) % 4;
        if (n4 == 2) {
            return -1;
        }
        int n5 = n < n2 ? n : n2;
        int n6 = n3 = n > n2 ? n : n2;
        if (n5 == 0 && n3 == 3) {
            return 3;
        }
        return n5;
    }

    public static boolean isInHalfPlane(int n, int n2) {
        if (n2 == 3) {
            return n == 3 || n == 0;
        }
        return n == n2 || n == n2 + 1;
    }

    public static boolean isNorthern(int n) {
        return n == 0 || n == 1;
    }
}

