/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.EdgeEndStar;
import com.vividsolutions.jts.graph.GraphComponent;
import com.vividsolutions.jts.graph.Label;
import java.io.PrintStream;

public class Node
extends GraphComponent {
    protected Coordinate coord;
    protected EdgeEndStar edges;

    public Node(Coordinate coordinate, EdgeEndStar edgeEndStar) {
        this.coord = coordinate;
        this.edges = edgeEndStar;
        this.label = new Label(0, -1);
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public EdgeEndStar getEdges() {
        return this.edges;
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    protected void computeIM(IntersectionMatrix intersectionMatrix) {
    }

    public void add(EdgeEnd edgeEnd) {
        this.edges.insert(edgeEnd);
        edgeEnd.setNode(this);
    }

    public void mergeLabel(Node node) {
        this.mergeLabel(node.label);
    }

    public void mergeLabel(Label label) {
        int n = 0;
        while (n < 2) {
            int n2 = this.computeMergedLocation(label, n);
            int n3 = this.label.getLocation(n);
            if (n3 == -1) {
                this.label.setLocation(n, n2);
            }
            ++n;
        }
    }

    public void setLabel(int n, int n2) {
        if (this.label == null) {
            this.label = new Label(n, n2);
        } else {
            this.label.setLocation(n, n2);
        }
    }

    public void setLabelBoundary(int n) {
        int n2;
        int n3 = -1;
        if (this.label != null) {
            n3 = this.label.getLocation(n);
        }
        switch (n3) {
            case 1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        this.label.setLocation(n, n2);
    }

    int computeMergedLocation(Label label, int n) {
        int n2 = -1;
        n2 = this.label.getLocation(n);
        if (!label.isNull(n)) {
            int n3 = label.getLocation(n);
            if (n2 != 1) {
                n2 = n3;
            }
        }
        return n2;
    }

    public void print(PrintStream printStream) {
        printStream.println("node " + this.coord + " lbl: " + this.label);
    }
}

