/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.graph.DirectedEdge;
import com.vividsolutions.jts.graph.DirectedEdgeStar;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class EdgeRing {
    protected DirectedEdge startDe;
    private int maxNodeDegree = -1;
    private List edges = new ArrayList();
    private List pts = new ArrayList();
    private Label label = new Label(-1);
    private LinearRing ring;
    private boolean isHole;
    private EdgeRing shell;
    private ArrayList holes = new ArrayList();
    protected GeometryFactory geometryFactory;
    protected CGAlgorithms cga;

    public EdgeRing(DirectedEdge directedEdge, GeometryFactory geometryFactory, CGAlgorithms cGAlgorithms) {
        this.geometryFactory = geometryFactory;
        this.cga = cGAlgorithms;
        this.computePoints(directedEdge);
        this.computeRing();
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public Coordinate getCoordinate(int n) {
        return (Coordinate)this.pts.get(n);
    }

    public LinearRing getLinearRing() {
        return this.ring;
    }

    public Label getLabel() {
        return this.label;
    }

    public boolean isShell() {
        return this.shell == null;
    }

    public EdgeRing getShell() {
        return this.shell;
    }

    public void setShell(EdgeRing edgeRing) {
        this.shell = edgeRing;
        if (edgeRing != null) {
            edgeRing.addHole(this);
        }
    }

    public void addHole(EdgeRing edgeRing) {
        this.holes.add(edgeRing);
    }

    public Polygon toPolygon(GeometryFactory geometryFactory) {
        LinearRing[] linearRingArray = new LinearRing[this.holes.size()];
        int n = 0;
        while (n < this.holes.size()) {
            linearRingArray[n] = ((EdgeRing)this.holes.get(n)).getLinearRing();
            ++n;
        }
        Polygon polygon = geometryFactory.createPolygon(this.getLinearRing(), linearRingArray);
        return polygon;
    }

    public void computeRing() {
        if (this.ring != null) {
            return;
        }
        Coordinate[] coordinateArray = new Coordinate[this.pts.size()];
        int n = 0;
        while (n < this.pts.size()) {
            coordinateArray[n] = (Coordinate)this.pts.get(n);
            ++n;
        }
        this.ring = this.geometryFactory.createLinearRing(coordinateArray);
        this.isHole = this.cga.isCCW(this.ring.getCoordinates());
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public List getEdges() {
        return this.edges;
    }

    protected void computePoints(DirectedEdge directedEdge) {
        this.startDe = directedEdge;
        DirectedEdge directedEdge2 = directedEdge;
        boolean bl = true;
        do {
            Assert.isTrue(directedEdge2 != null, "found null Directed Edge");
            this.edges.add(directedEdge2);
            Label label = directedEdge2.getLabel();
            Assert.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(directedEdge2.getEdge(), directedEdge2.isForward(), bl);
            bl = false;
            this.setEdgeRing(directedEdge2, this);
        } while ((directedEdge2 = this.getNext(directedEdge2)) != this.startDe);
    }

    public int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    private void computeMaxNodeDegree() {
        this.maxNodeDegree = 0;
        DirectedEdge directedEdge = this.startDe;
        do {
            Node node;
            int n;
            if ((n = ((DirectedEdgeStar)(node = directedEdge.getNode()).getEdges()).getOutgoingDegree(this)) <= this.maxNodeDegree) continue;
            this.maxNodeDegree = n;
        } while ((directedEdge = this.getNext(directedEdge)) != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public void setInResult() {
        DirectedEdge directedEdge = this.startDe;
        do {
            directedEdge.getEdge().setInResult(true);
        } while ((directedEdge = directedEdge.getNext()) != this.startDe);
    }

    protected void mergeLabel(Label label) {
        this.mergeLabel(label, 0);
        this.mergeLabel(label, 1);
    }

    protected void mergeLabel(Label label, int n) {
        int n2 = label.getLocation(n, 2);
        if (n2 == -1) {
            return;
        }
        if (this.label.getLocation(n) == -1) {
            this.label.setLocation(n, n2);
            return;
        }
    }

    protected void addPoints(Edge edge, boolean bl, boolean bl2) {
        Coordinate[] coordinateArray = edge.getCoordinates();
        if (bl) {
            int n = 1;
            if (bl2) {
                n = 0;
            }
            int n2 = n;
            while (n2 < coordinateArray.length) {
                this.pts.add(coordinateArray[n2]);
                ++n2;
            }
        } else {
            int n = coordinateArray.length - 2;
            if (bl2) {
                n = coordinateArray.length - 1;
            }
            int n3 = n;
            while (n3 >= 0) {
                this.pts.add(coordinateArray[n3]);
                --n3;
            }
        }
    }

    public boolean containsPoint(Coordinate coordinate) {
        LinearRing linearRing = this.getLinearRing();
        Envelope envelope = linearRing.getEnvelopeInternal();
        if (!envelope.contains(coordinate)) {
            return false;
        }
        if (!this.cga.isPointInRing(coordinate, linearRing.getCoordinates())) {
            return false;
        }
        Iterator iterator = ((AbstractList)this.holes).iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            if (!edgeRing.containsPoint(coordinate)) continue;
            return false;
        }
        return true;
    }
}

