/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeIntersection;
import com.vividsolutions.jts.graph.Label;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class EdgeIntersectionList {
    List list = new ArrayList();
    Edge edge;

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
    }

    public EdgeIntersection add(Coordinate coordinate, int n, double d) {
        EdgeIntersection edgeIntersection;
        ListIterator<EdgeIntersection> listIterator = this.list.listIterator();
        boolean bl = this.findInsertionPoint(n, d, listIterator);
        if (!bl) {
            edgeIntersection = new EdgeIntersection(coordinate, n, d);
            listIterator.add(edgeIntersection);
        } else {
            edgeIntersection = (EdgeIntersection)listIterator.next();
        }
        return edgeIntersection;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public boolean isEmpty() {
        Iterator iterator = this.list.iterator();
        return !iterator.hasNext();
    }

    boolean findInsertionPoint(int n, double d, ListIterator listIterator) {
        ListIterator listIterator2 = this.list.listIterator();
        boolean bl = false;
        while (listIterator2.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)listIterator2.next();
            int n2 = edgeIntersection.compare(n, d);
            if (n2 == 0) {
                return true;
            }
            if (n2 > 0) {
                return false;
            }
            listIterator.next();
        }
        return false;
    }

    public boolean isIntersection(Coordinate coordinate) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
            if (!edgeIntersection.coord.equals(coordinate)) continue;
            return true;
        }
        return false;
    }

    public void addEndpoints() {
        int n = this.edge.pts.length - 1;
        this.add(this.edge.pts[0], 0, 0.0);
        this.add(this.edge.pts[n], n, 0.0);
    }

    public void addSplitEdges(List list) {
        this.addEndpoints();
        Iterator iterator = this.list.iterator();
        EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection2 = (EdgeIntersection)iterator.next();
            Edge edge = this.createSplitEdge(edgeIntersection, edgeIntersection2);
            list.add(edge);
            edgeIntersection = edgeIntersection2;
        }
    }

    Edge createSplitEdge(EdgeIntersection edgeIntersection, EdgeIntersection edgeIntersection2) {
        boolean bl;
        int n = edgeIntersection2.segmentIndex - edgeIntersection.segmentIndex + 2;
        Coordinate coordinate = this.edge.pts[edgeIntersection2.segmentIndex];
        boolean bl2 = bl = edgeIntersection2.dist > 0.0 || !edgeIntersection2.coord.equals2D(coordinate);
        if (!bl) {
            --n;
        }
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        coordinateArray[n2++] = new Coordinate(edgeIntersection.coord);
        int n3 = edgeIntersection.segmentIndex + 1;
        while (n3 <= edgeIntersection2.segmentIndex) {
            coordinateArray[n2++] = this.edge.pts[n3];
            ++n3;
        }
        if (bl) {
            coordinateArray[n2] = edgeIntersection2.coord;
        }
        return new Edge(coordinateArray, new Label(this.edge.label));
    }

    public void print(PrintStream printStream) {
        printStream.println("Intersections:");
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
            edgeIntersection.print(printStream);
        }
    }
}

