/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.algorithm.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class EdgeEndStar {
    protected Map edgeMap = new TreeMap();
    protected List edgeList;
    private int[] ptInAreaLocation = new int[]{-1, -1};

    public abstract void insert(EdgeEnd var1);

    protected void insertEdgeEnd(EdgeEnd edgeEnd, Object object) {
        this.edgeMap.put(edgeEnd, object);
        this.edgeList = null;
    }

    public Coordinate getCoordinate() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
        return edgeEnd.getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap.size();
    }

    public Iterator iterator() {
        return this.getEdges().iterator();
    }

    public List getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList(this.edgeMap.values());
        }
        return this.edgeList;
    }

    public EdgeEnd getNextCW(EdgeEnd edgeEnd) {
        this.getEdges();
        int n = this.edgeList.indexOf(edgeEnd);
        int n2 = n - 1;
        if (n == 0) {
            n2 = this.edgeList.size() - 1;
        }
        return (EdgeEnd)this.edgeList.get(n2);
    }

    public void computeLabelling(GeometryGraph[] geometryGraphArray) {
        Object object;
        Object object2;
        this.computeEdgeEndLabels();
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] blArray = new boolean[]{false, false};
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object2 = (EdgeEnd)iterator.next();
            object = ((EdgeEnd)object2).getLabel();
            int n = 0;
            while (n < 2) {
                if (((Label)object).isLine(n) && ((Label)object).getLocation(n) == 1) {
                    blArray[n] = true;
                }
                ++n;
            }
        }
        object2 = this.iterator();
        while (object2.hasNext()) {
            object = (EdgeEnd)object2.next();
            Label label = ((EdgeEnd)object).getLabel();
            int n = 0;
            while (n < 2) {
                if (label.isAnyNull(n)) {
                    int n2 = -1;
                    if (blArray[n]) {
                        n2 = 2;
                    } else {
                        Coordinate coordinate = ((EdgeEnd)object).getCoordinate();
                        n2 = this.getLocation(n, coordinate, geometryGraphArray);
                    }
                    label.setAllLocationsIfNull(n, n2);
                }
                ++n;
            }
        }
    }

    private void computeEdgeEndLabels() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            edgeEnd.computeLabel();
        }
    }

    int getLocation(int n, Coordinate coordinate, GeometryGraph[] geometryGraphArray) {
        if (this.ptInAreaLocation[n] == -1) {
            this.ptInAreaLocation[n] = SimplePointInAreaLocator.locate(coordinate, geometryGraphArray[n].getGeometry());
        }
        return this.ptInAreaLocation[n];
    }

    public boolean isAreaLabelsConsistent() {
        this.computeEdgeEndLabels();
        return this.checkAreaLabelsConsistent(0);
    }

    private boolean checkAreaLabelsConsistent(int n) {
        List list = this.getEdges();
        if (list.size() <= 0) {
            return true;
        }
        int n2 = list.size() - 1;
        Label label = ((EdgeEnd)list.get(n2)).getLabel();
        int n3 = label.getLocation(n, 1);
        Assert.isTrue(n3 != -1, "Found unlabelled area edge");
        int n4 = n3;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            Label label2 = edgeEnd.getLabel();
            Assert.isTrue(label2.isArea(n), "Found non-area edge");
            int n5 = label2.getLocation(n, 1);
            int n6 = label2.getLocation(n, 2);
            if (n5 == n6) {
                return false;
            }
            if (n6 != n4) {
                return false;
            }
            n4 = n5;
        }
        return true;
    }

    void propagateSideLabels(int n) {
        Object object;
        int n2 = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            object = edgeEnd.getLabel();
            if (!((Label)object).isArea(n) || ((Label)object).getLocation(n, 1) == -1) continue;
            n2 = ((Label)object).getLocation(n, 1);
        }
        if (n2 == -1) {
            return;
        }
        int n3 = n2;
        object = this.iterator();
        while (object.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)object.next();
            Label label = edgeEnd.getLabel();
            if (label.getLocation(n, 0) == -1) {
                label.setLocation(n, 0, n3);
            }
            if (!label.isArea(n)) continue;
            int n4 = label.getLocation(n, 1);
            int n5 = label.getLocation(n, 2);
            if (n5 != -1) {
                if (n5 != n3) {
                    throw new TopologyException("side location conflict", edgeEnd.getCoordinate());
                }
                if (n4 == -1) {
                    Assert.shouldNeverReachHere("found single null side (at " + edgeEnd.getCoordinate() + ")");
                }
                n3 = n4;
                continue;
            }
            Assert.isTrue(label.getLocation(n, 1) == -1, "found single null side");
            label.setLocation(n, 2, n3);
            label.setLocation(n, 1, n3);
        }
    }

    public int findIndex(EdgeEnd edgeEnd) {
        this.iterator();
        int n = 0;
        while (n < this.edgeList.size()) {
            EdgeEnd edgeEnd2 = (EdgeEnd)this.edgeList.get(n);
            if (edgeEnd2 == edgeEnd) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void print(PrintStream printStream) {
        System.out.println("EdgeEndStar:   " + this.getCoordinate());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            edgeEnd.print(printStream);
        }
    }
}

