/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.graph.DirectedEdge;
import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.EdgeEndStar;
import com.vividsolutions.jts.graph.EdgeRing;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Quadrant;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar
extends EdgeEndStar {
    private List resultAreaEdgeList;
    private Label label;
    private final int SCANNING_FOR_INCOMING = 1;
    private final int LINKING_TO_OUTGOING = 2;

    public void insert(EdgeEnd edgeEnd) {
        DirectedEdge directedEdge = (DirectedEdge)edgeEnd;
        this.insertEdgeEnd(directedEdge, directedEdge);
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isInResult()) continue;
            ++n;
        }
        return n;
    }

    public int getOutgoingDegree(EdgeRing edgeRing) {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (directedEdge.getEdgeRing() != edgeRing) continue;
            ++n;
        }
        return n;
    }

    public DirectedEdge getRightmostEdge() {
        List list = this.getEdges();
        int n = list.size();
        if (n < 1) {
            return null;
        }
        DirectedEdge directedEdge = (DirectedEdge)list.get(0);
        if (n == 1) {
            return directedEdge;
        }
        DirectedEdge directedEdge2 = (DirectedEdge)list.get(n - 1);
        int n2 = directedEdge.getQuadrant();
        int n3 = directedEdge2.getQuadrant();
        if (Quadrant.isNorthern(n2) && Quadrant.isNorthern(n3)) {
            return directedEdge;
        }
        if (!Quadrant.isNorthern(n2) && !Quadrant.isNorthern(n3)) {
            return directedEdge2;
        }
        Object var7_7 = null;
        if (directedEdge.getDy() != 0.0) {
            return directedEdge;
        }
        if (directedEdge2.getDy() != 0.0) {
            return directedEdge2;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    public void computeLabelling(GeometryGraph[] geometryGraphArray) {
        super.computeLabelling(geometryGraphArray);
        this.label = new Label(-1);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            Edge edge = edgeEnd.getEdge();
            Label label = edge.getLabel();
            int n = 0;
            while (n < 2) {
                int n2 = label.getLocation(n);
                if (n2 == 0 || n2 == 1) {
                    this.label.setLocation(n, 0);
                }
                ++n;
            }
        }
    }

    public void mergeSymLabels() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            Label label = directedEdge.getLabel();
            label.merge(directedEdge.getSym().getLabel());
        }
    }

    public void updateLabelling(Label label) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            Label label2 = directedEdge.getLabel();
            label2.setAllLocationsIfNull(0, label.getLocation(0));
            label2.setAllLocationsIfNull(1, label.getLocation(1));
        }
    }

    private List getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            return this.resultAreaEdgeList;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isInResult() && !directedEdge.getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(directedEdge);
        }
        return this.resultAreaEdgeList;
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = 1;
        int n2 = 0;
        while (n2 < this.resultAreaEdgeList.size()) {
            DirectedEdge directedEdge3 = (DirectedEdge)this.resultAreaEdgeList.get(n2);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (directedEdge3.getLabel().isArea()) {
                if (directedEdge == null && directedEdge3.isInResult()) {
                    directedEdge = directedEdge3;
                }
                switch (n) {
                    case 1: {
                        if (!directedEdge4.isInResult()) break;
                        directedEdge2 = directedEdge4;
                        n = 2;
                        break;
                    }
                    case 2: {
                        if (!directedEdge3.isInResult()) break;
                        directedEdge2.setNext(directedEdge3);
                        n = 1;
                    }
                }
            }
            ++n2;
        }
        if (n == 2) {
            if (directedEdge == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.isTrue(directedEdge.isInResult(), "unable to link last incoming dirEdge");
            directedEdge2.setNext(directedEdge);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing edgeRing) {
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = 1;
        int n2 = this.resultAreaEdgeList.size() - 1;
        while (n2 >= 0) {
            DirectedEdge directedEdge3 = (DirectedEdge)this.resultAreaEdgeList.get(n2);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (directedEdge == null && directedEdge3.getEdgeRing() == edgeRing) {
                directedEdge = directedEdge3;
            }
            switch (n) {
                case 1: {
                    if (directedEdge4.getEdgeRing() != edgeRing) break;
                    directedEdge2 = directedEdge4;
                    n = 2;
                    break;
                }
                case 2: {
                    if (directedEdge3.getEdgeRing() != edgeRing) break;
                    directedEdge2.setNextMin(directedEdge3);
                    n = 1;
                }
            }
            --n2;
        }
        if (n == 2) {
            Assert.isTrue(directedEdge != null, "found null for first outgoing dirEdge");
            Assert.isTrue(directedEdge.getEdgeRing() == edgeRing, "unable to link last incoming dirEdge");
            directedEdge2.setNextMin(directedEdge);
        }
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = this.edgeList.size() - 1;
        while (n >= 0) {
            DirectedEdge directedEdge3 = (DirectedEdge)this.edgeList.get(n);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (directedEdge2 == null) {
                directedEdge2 = directedEdge4;
            }
            if (directedEdge != null) {
                directedEdge4.setNext(directedEdge);
            }
            directedEdge = directedEdge3;
            --n;
        }
        directedEdge2.setNext(directedEdge);
    }

    public void findCoveredLineEdges() {
        Object object;
        int n = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            object = directedEdge.getSym();
            if (directedEdge.isLineEdge()) continue;
            if (directedEdge.isInResult()) {
                n = 0;
                break;
            }
            if (!((DirectedEdge)object).isInResult()) continue;
            n = 2;
            break;
        }
        if (n == -1) {
            return;
        }
        int n2 = n;
        object = this.iterator();
        while (object.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)object.next();
            DirectedEdge directedEdge2 = directedEdge.getSym();
            if (directedEdge.isLineEdge()) {
                directedEdge.getEdge().setCovered(n2 == 0);
                continue;
            }
            if (directedEdge.isInResult()) {
                n2 = 2;
            }
            if (!directedEdge2.isInResult()) continue;
            n2 = 0;
        }
    }

    public void computeDepths(DirectedEdge directedEdge) {
        int n = this.findIndex(directedEdge);
        Label label = directedEdge.getLabel();
        int n2 = directedEdge.getDepth(1);
        int n3 = this.computeDepths(n + 1, this.edgeList.size() - 1, n2);
        int n4 = this.computeDepths(0, n, n3);
        Assert.isTrue(n4 == n2, "depth mismatch at " + directedEdge.getCoordinate());
    }

    private int computeDepths(int n, int n2, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 <= n2) {
            DirectedEdge directedEdge = (DirectedEdge)this.edgeList.get(n5);
            Label label = directedEdge.getLabel();
            directedEdge.setEdgeDepths(2, n4);
            n4 = directedEdge.getDepth(1);
            ++n5;
        }
        return n4;
    }

    public void print(PrintStream printStream) {
        System.out.println("DirectedEdgeStar: " + this.getCoordinate());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            printStream.print("out ");
            directedEdge.print(printStream);
            printStream.println();
            printStream.print("in ");
            directedEdge.getSym().print(printStream);
            printStream.println();
        }
    }
}

