/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.graph;

import com.vividsolutions.jts.graph.Edge;
import com.vividsolutions.jts.graph.EdgeEnd;
import com.vividsolutions.jts.graph.EdgeRing;
import com.vividsolutions.jts.graph.Label;
import com.vividsolutions.jts.graph.Position;
import java.io.PrintStream;

public class DirectedEdge
extends EdgeEnd {
    protected boolean isForward;
    private boolean isInResult = false;
    private boolean isVisited = false;
    private DirectedEdge sym;
    private DirectedEdge next;
    private DirectedEdge nextMin;
    private EdgeRing edgeRing;
    private EdgeRing minEdgeRing;
    private int[] depth = new int[]{0, -999, -999};

    public static int depthFactor(int n, int n2) {
        if (n == 2 && n2 == 0) {
            return 1;
        }
        if (n == 0 && n2 == 2) {
            return -1;
        }
        return 0;
    }

    public DirectedEdge(Edge edge, boolean bl) {
        super(edge);
        this.isForward = bl;
        if (bl) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int n = edge.getNumPoints() - 1;
            this.init(edge.getCoordinate(n), edge.getCoordinate(n - 1));
        }
        this.computeDirectedLabel();
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void setInResult(boolean bl) {
        this.isInResult = bl;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean bl) {
        this.isVisited = bl;
    }

    public void setEdgeRing(EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    public EdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public void setMinEdgeRing(EdgeRing edgeRing) {
        this.minEdgeRing = edgeRing;
    }

    public EdgeRing getMinEdgeRing() {
        return this.minEdgeRing;
    }

    public int getDepth(int n) {
        return this.depth[n];
    }

    public void setDepth(int n, int n2) {
        this.depth[n] = n2;
    }

    public void setVisitedEdge(boolean bl) {
        this.setVisited(bl);
        this.sym.setVisited(bl);
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setSym(DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    public DirectedEdge getNext() {
        return this.next;
    }

    public void setNext(DirectedEdge directedEdge) {
        this.next = directedEdge;
    }

    public DirectedEdge getNextMin() {
        return this.nextMin;
    }

    public void setNextMin(DirectedEdge directedEdge) {
        this.nextMin = directedEdge;
    }

    public boolean isLineEdge() {
        boolean bl = this.label.isLine(0) || this.label.isLine(1);
        boolean bl2 = !this.label.isArea(0) || this.label.allPositionsEqual(0, 2);
        boolean bl3 = !this.label.isArea(1) || this.label.allPositionsEqual(1, 2);
        return bl && bl2 && bl3;
    }

    public boolean isInteriorAreaEdge() {
        boolean bl = true;
        int n = 0;
        while (n < 2) {
            if (!this.label.isArea(n) || this.label.getLocation(n, 1) != 0 || this.label.getLocation(n, 2) != 0) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private void computeDirectedLabel() {
        this.label = new Label(this.edge.getLabel());
        if (!this.isForward) {
            this.label.flip();
        }
    }

    public void setEdgeDepths(int n, int n2) {
        int n3 = this.getEdge().getDepthDelta();
        int n4 = this.label.getLocation(0, n);
        int n5 = Position.opposite(n);
        int n6 = this.label.getLocation(0, n5);
        int n7 = Math.abs(n3) * DirectedEdge.depthFactor(n4, n6);
        int n8 = n2 + n7;
        this.setDepth(n, n2);
        this.setDepth(n5, n8);
    }

    public void print(PrintStream printStream) {
        super.print(printStream);
        printStream.print(" " + this.depth[1] + "/" + this.depth[2]);
        if (this.isInResult) {
            printStream.print(" inResult");
        }
    }

    public void printEdge(PrintStream printStream) {
        this.print(printStream);
        printStream.print(" ");
        if (this.isForward) {
            this.edge.print(printStream);
        } else {
            this.edge.printReverse(printStream);
        }
    }
}

