/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;

public class PrecisionModel
implements Serializable,
Comparable {
    public static final int FIXED = 1;
    public static final int FLOATING = 2;
    public static final double maximumPreciseValue = 9.007199254740992E15;
    private int modelType = 0;
    private double scale;
    private double offsetX;
    private double offsetY;

    public PrecisionModel() {
        this.modelType = 2;
    }

    public PrecisionModel(double d, double d2, double d3) {
        this.modelType = 1;
        this.setScale(d);
        this.offsetX = d2;
        this.offsetY = d3;
    }

    public PrecisionModel(double d) {
        this.modelType = 1;
        this.setScale(d);
        this.offsetX = 0.0;
        this.offsetY = 0.0;
    }

    public PrecisionModel(PrecisionModel precisionModel) {
        this.modelType = precisionModel.modelType;
        this.scale = precisionModel.scale;
        this.offsetX = precisionModel.offsetX;
        this.offsetY = precisionModel.offsetY;
    }

    public boolean isFloating() {
        return this.modelType == 2;
    }

    public double getScale() {
        return this.scale;
    }

    private void setScale(double d) {
        this.scale = Math.abs(d);
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void toInternal(Coordinate coordinate, Coordinate coordinate2) {
        if (this.isFloating()) {
            coordinate2.x = coordinate.x;
            coordinate2.y = coordinate.y;
        } else {
            coordinate2.x = this.makePrecise(coordinate.x);
            coordinate2.y = this.makePrecise(coordinate.y);
        }
        coordinate2.z = coordinate.z;
    }

    public Coordinate toInternal(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate();
        this.toInternal(coordinate, coordinate2);
        return coordinate2;
    }

    public Coordinate toExternal(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate();
        this.toExternal(coordinate, coordinate2);
        return coordinate2;
    }

    public void toExternal(Coordinate coordinate, Coordinate coordinate2) {
        coordinate2.x = coordinate.x;
        coordinate2.y = coordinate.y;
    }

    public double makePrecise(double d) {
        return Math.rint(d * this.scale) / this.scale;
    }

    public void makePrecise(Coordinate coordinate) {
        if (this.modelType == 2) {
            return;
        }
        coordinate.x = this.makePrecise(coordinate.x);
        coordinate.y = this.makePrecise(coordinate.y);
    }

    public String toString() {
        String string;
        if (this.isFloating()) {
            string = "Floating";
        } else {
            string = "Fixed ( Scale = " + this.getScale();
            string = string + " )";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrecisionModel)) {
            return false;
        }
        PrecisionModel precisionModel = (PrecisionModel)object;
        return this.modelType == precisionModel.modelType && this.offsetX == precisionModel.offsetX && this.offsetY == precisionModel.offsetY && this.scale == precisionModel.scale;
    }

    public int compareTo(Object object) {
        PrecisionModel precisionModel = (PrecisionModel)object;
        if (this.modelType == 2 && precisionModel.modelType == 2) {
            return 0;
        }
        if (this.modelType == 2 && precisionModel.modelType != 2) {
            return 1;
        }
        if (this.modelType != 2 && precisionModel.modelType == 2) {
            return -1;
        }
        if (this.modelType == 1 && precisionModel.modelType == 1) {
            if (this.scale > precisionModel.scale) {
                return 1;
            }
            if (this.scale < precisionModel.scale) {
                return -1;
            }
            return 0;
        }
        Assert.shouldNeverReachHere("Unknown Precision Model type encountered");
        return 0;
    }
}

